
package com.gubse.ifs.sihotservices01;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlSeeAlso;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.9-b130926.1035
 * Generated source version: 2.2
 * 
 */
@WebService(name = "SihotServices01PortType", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.wsdl")
@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
@XmlSeeAlso({
    ObjectFactory.class
})
public interface SihotServices01PortType {


    /**
     * 
     * This service performs an authentication and get a securityID
     * 
     * AuthenticationInfos (Input)
     * 	user (string, User)
     * 	password (string, Passwort)
     * 	hotel (Integer, Hotel)
     * 	hoteldate (Date, Hoteltag)
     * 	useldap (Bool, LDAP verwenden) - [0, 1]
     * 
     * Authentication (Output)
     * 	SecurityID (string, Sicherheits-ID)
     * 	ValidFromUTC (string, gltig von)
     * 	ValidUntilUTC (string, gltig bis)
     * 	DurationInSec (Integer, Zeitdauer (in Sekunden))
     * 
     * <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:c="http://www.gubse.com/IFS/C_SAKUBA_MEAL_PLAN_SUMMARY.xsd">
     *    <soapenv:Header/>
     *    <soapenv:Body>
     *       <c:AuthenticateRequest>
     *          <!--Optional:-->
     *          <c:TransactionID></c:TransactionID>
     *          <c:AuthenticationInfos>
     *             <c:user>API</c:user>
     *             <c:password>Sihot2019!</c:password>
     *             <c:hotel>1</c:hotel>
     *             <!--Optional:-->
     *             <c:hoteldate></c:hoteldate>
     *             <!--Optional:-->
     *             <c:useldap></c:useldap>
     *          </c:AuthenticationInfos>
     *       </c:AuthenticateRequest>
     *    </soapenv:Body>
     * </soapenv:Envelope>
     * 
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.AuthenticateResponse
     */
    @WebMethod(operationName = "Authenticate")
    @WebResult(name = "AuthenticateResponse", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public AuthenticateResponse authenticate(
        @WebParam(name = "AuthenticateRequest", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        AuthenticateRequest body);

    /**
     * 
     * 			This service perform a gift voucher redemption:
     * 		       
     * 			INPUT: 
     * 			- accountObjID: unique id of a account
     * 			- accountType: type of the account; x = guest accoumt, y = client account, D = misc account, G = group account, R = reservation account, V = gift voucher account
     * 			- giftVoucherNo: gift voucher number
     * 			- hotelSell: gift voucher hotel sell
     * 			
     * 			Output (redeemed gift voucher):
     * 			- objid: unique id
     * 			- status: 1 = valid, 2 = not valid, 3 = redeemed, 4 = invoiced, 5 = suspended, 6 = incomplete, 7 = unavailable
     * 			- number, externalReference
     * 			- amount
     * 			- sellDate, hotelSell, expiryDate
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.GIFTVOUCHERREDEEMV01Response
     */
    @WebMethod(operationName = "GIFT_VOUCHER_REDEEM_V01")
    @WebResult(name = "GIFT_VOUCHER_REDEEM_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public GIFTVOUCHERREDEEMV01Response giftVOUCHERREDEEMV01(
        @WebParam(name = "GIFT_VOUCHER_REDEEM_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        GIFTVOUCHERREDEEMV01Request body);

    /**
     * 
     * 		This service searches for gift vouchers:
     * 	       
     * 		INPUT (searchcriteria): 
     * 		- sellDate (compulusory), sellTo: Period of sell date 
     * 		- giftVoucherNoFrom, giftVoucherNoTo: gift voucher number
     * 		- externalReference
     * 		- blocked, all, open: gift voucher state; only one field may be set with 1
     * 		- holderName
     * 		
     * 		Output (List of gift vouchers):
     * 		- objid: unique id
     * 		- status: 1 = valid, 2 = not valid, 3 = redeemed, 4 = invoiced, 5 = suspended, 6 = incomplete, 7 = unavailable
     * 		- number, externalReference
     * 		- amount
     * 		- sellDate, hotelSell, expiryDate
     * 		- gift voucher holder:
     * 		  - objid, lastName, matchcode
     * 		  - guestHotel, guestNo
     * 	
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.GIFTVOUCHERSEARCHV01Response
     */
    @WebMethod(operationName = "GIFT_VOUCHER_SEARCH_V01")
    @WebResult(name = "GIFT_VOUCHER_SEARCH_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public GIFTVOUCHERSEARCHV01Response giftVOUCHERSEARCHV01(
        @WebParam(name = "GIFT_VOUCHER_SEARCH_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        GIFTVOUCHERSEARCHV01Request body);

    /**
     * 
     * 		This service perform a gift voucher sell:
     * 	       
     * 		INPUT: 
     * 		- guestObjID: unique id of a guest
     * 		- serviceCode: service code
     * 		- amount: amount of the gift voucher
     * 		- typeOfPayment: type of payment
     * 		
     * 		Output (new gift voucher):
     * 		- objid: unique id
     * 		- status: 1 = valid, 2 = not valid, 3 = redeemed, 4 = invoiced, 5 = suspended, 6 = incomplete, 7 = unavailable
     * 		- number, externalReference
     * 		- amount
     * 		- sellDate, hotelSell, expiryDate
     * 	
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.GIFTVOUCHERSELLV01Response
     */
    @WebMethod(operationName = "GIFT_VOUCHER_SELL_V01")
    @WebResult(name = "GIFT_VOUCHER_SELL_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public GIFTVOUCHERSELLV01Response giftVOUCHERSELLV01(
        @WebParam(name = "GIFT_VOUCHER_SELL_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        GIFTVOUCHERSELLV01Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.GetCategoryMappingResponse
     */
    @WebMethod(operationName = "GetCategoryMapping")
    @WebResult(name = "GetCategoryMappingResponse", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public GetCategoryMappingResponse getCategoryMapping(
        @WebParam(name = "GetCategoryMappingRequest", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        GetCategoryMappingRequest body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.GetPackageMappingResponse
     */
    @WebMethod(operationName = "GetPackageMapping")
    @WebResult(name = "GetPackageMappingResponse", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public GetPackageMappingResponse getPackageMapping(
        @WebParam(name = "GetPackageMappingRequest", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        GetPackageMappingRequest body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.GetServiceMappingResponse
     */
    @WebMethod(operationName = "GetServiceMapping")
    @WebResult(name = "GetServiceMappingResponse", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public GetServiceMappingResponse getServiceMapping(
        @WebParam(name = "GetServiceMappingRequest", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        GetServiceMappingRequest body);

    /**
     * 
     * 			GENERAL:
     * 				This service add a service to a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTADDSERVICEV001Response
     */
    @WebMethod(operationName = "S_ACCOUNT_ADD_SERVICE_V001")
    @WebResult(name = "S_ACCOUNT_ADD_SERVICE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTADDSERVICEV001Response sACCOUNTADDSERVICEV001(
        @WebParam(name = "S_ACCOUNT_ADD_SERVICE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTADDSERVICEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add a service to a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTADDSERVICEV002Response
     */
    @WebMethod(operationName = "S_ACCOUNT_ADD_SERVICE_V002")
    @WebResult(name = "S_ACCOUNT_ADD_SERVICE_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTADDSERVICEV002Response sACCOUNTADDSERVICEV002(
        @WebParam(name = "S_ACCOUNT_ADD_SERVICE_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTADDSERVICEV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add a service to a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTADDSERVICEV003Response
     */
    @WebMethod(operationName = "S_ACCOUNT_ADD_SERVICE_V003")
    @WebResult(name = "S_ACCOUNT_ADD_SERVICE_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTADDSERVICEV003Response sACCOUNTADDSERVICEV003(
        @WebParam(name = "S_ACCOUNT_ADD_SERVICE_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTADDSERVICEV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add a service to a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTADDSERVICEWITHMANUALRATEV001Response
     */
    @WebMethod(operationName = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001")
    @WebResult(name = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTADDSERVICEWITHMANUALRATEV001Response sACCOUNTADDSERVICEWITHMANUALRATEV001(
        @WebParam(name = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTADDSERVICEWITHMANUALRATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add a service to a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTADDSERVICEWITHMANUALRATEV002Response
     */
    @WebMethod(operationName = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002")
    @WebResult(name = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTADDSERVICEWITHMANUALRATEV002Response sACCOUNTADDSERVICEWITHMANUALRATEV002(
        @WebParam(name = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTADDSERVICEWITHMANUALRATEV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add a service to a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTADDSERVICEWITHMANUALRATEV003Response
     */
    @WebMethod(operationName = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003")
    @WebResult(name = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTADDSERVICEWITHMANUALRATEV003Response sACCOUNTADDSERVICEWITHMANUALRATEV003(
        @WebParam(name = "S_ACCOUNT_ADD_SERVICE_WITH_MANUAL_RATE_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTADDSERVICEWITHMANUALRATEV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service canceled a service from a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTCANCELSERVICEV001Response
     */
    @WebMethod(operationName = "S_ACCOUNT_CANCEL_SERVICE_V001")
    @WebResult(name = "S_ACCOUNT_CANCEL_SERVICE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTCANCELSERVICEV001Response sACCOUNTCANCELSERVICEV001(
        @WebParam(name = "S_ACCOUNT_CANCEL_SERVICE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTCANCELSERVICEV001Request body);

    /**
     * 		
     * GENERAL:
     * 	This service is used to add a payment posting to an existing account
     * 
     * INPUT:
     * 	ACCOUNT-OBJID		:	objID of the folio on which the payment should be posted
     * 	accountType		:	x for guest / y for orderer
     * 	externalIFPartner	:	combobox short cut of the allowed external interface partner. Could be defined in
     * 					"Methods of Payment" dialog 
     * 	typeofpayment		:	Type of payment short cut (e.g. "CA" for cash). Only types which are defined for the external interface partner are allowed!
     * 	amount			:	Amount. "." is used as decimal separator
     * 	currency		:	see combobox configuration for combobox type "49"
     * 	DESCRIPTION		:	description text for the posting	
     * 
     * OUTPUT:
     * 	PAYMENT-OBJID		:	objectID of the posting		
     *      
     * 
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTPAYMENTADDV001Response
     */
    @WebMethod(operationName = "S_ACCOUNT_PAYMENT_ADD_V001")
    @WebResult(name = "S_ACCOUNT_PAYMENT_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTPAYMENTADDV001Response sACCOUNTPAYMENTADDV001(
        @WebParam(name = "S_ACCOUNT_PAYMENT_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTPAYMENTADDV001Request body);

    /**
     * 		
     * GENERAL:
     * 	This service is used to add a payment posting to an existing account
     * 
     * INPUT:
     * 	ACCOUNT-OBJID		:	objID of the folio on which the payment should be posted
     * 	accountType		:	x for guest / y for orderer
     * 	externalIFPartner	:	combobox short cut of the allowed external interface partner. Could be defined in
     * 					"Methods of Payment" dialog 
     * 	typeofpayment		:	Type of payment short cut (e.g. "CA" for cash). Only types which are defined for the external interface partner are allowed!
     * 	amount			:	Amount. "." is used as decimal separator
     * 	currency		:	see combobox configuration for combobox type "49"
     * 	DESCRIPTION		:	description text for the posting	
     * 	isFromZPOS		:	Identification that this is a ZPOS
     * 
     * OUTPUT:
     * 	PAYMENT-OBJID		:	objectID of the posting		
     *      
     * 
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTPAYMENTADDV002Response
     */
    @WebMethod(operationName = "S_ACCOUNT_PAYMENT_ADD_V002")
    @WebResult(name = "S_ACCOUNT_PAYMENT_ADD_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTPAYMENTADDV002Response sACCOUNTPAYMENTADDV002(
        @WebParam(name = "S_ACCOUNT_PAYMENT_ADD_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTPAYMENTADDV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for accounts
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTSEARCHV001Response
     */
    @WebMethod(operationName = "S_ACCOUNT_SEARCH_V001")
    @WebResult(name = "S_ACCOUNT_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTSEARCHV001Response sACCOUNTSEARCHV001(
        @WebParam(name = "S_ACCOUNT_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service return a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACCOUNTV001Response
     */
    @WebMethod(operationName = "S_ACCOUNT_V001")
    @WebResult(name = "S_ACCOUNT_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACCOUNTV001Response sACCOUNTV001(
        @WebParam(name = "S_ACCOUNT_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACCOUNTV001Request body);

    /**
     *  
     * 			GENERAL:
     * 				This service is used to query ACL rights that apply to the current user as determined by the SecurityID.
     * 			
     * 			INPUT:
     * 				In addition to the SecurityID, the required ACL right must also be specified using type, key and subkey:
     * 				layout rights:		type:	0
     * 							key:	layout-id (example: ID_SIHOT_PACKAGE_MASTER)
     * 							subkey:	<empty>
     * 							right:	view right
     * 				function rights:	type:	1
     * 							key:	business object class (exampe: BO_PackageMasterFile)
     * 							subkey: function (example: update)
     * 							right:	execute right
     * 				relation rights:	type:	2
     * 							key:	business object class (exampe: BO_PackageMasterFile)
     * 							subkey: relation (example: getPartLists)
     * 							right:	execute right
     * 				batch rights:		type:	5
     * 							key:	batch name (exampe: anreiseliste)
     * 							subkey: <empty></empty>
     * 							right:	view right
     * 				service rights:		type:	6
     * 							key:	service id (exampe: GuestSearch)
     * 							subkey: <empty></empty>
     * 							right:	execute right							
     * 				feature rights:		type:	7
     * 							key:	feature number (exampe: 5 /* disable overbooking flag in a reservation *<!---->/)
     * 							subkey: <empty></empty>
     * 							right:	execute right										
     * 				
     * 			OUTPUT:
     * 				The service will return informationen about the required ACL right (execution right or view right; see above)
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACLINFOGETV001Response
     */
    @WebMethod(operationName = "S_ACL_INFO_GET_V001")
    @WebResult(name = "S_ACL_INFO_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACLINFOGETV001Response sACLINFOGETV001(
        @WebParam(name = "S_ACL_INFO_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACLINFOGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service is adds an activity in the trails
     * 				
     * 				ATTENTION!
     * 				You can add activities to any trail. SIHOT does not check if the activity is saved in the "correct" trail.
     * 				Please ensure that you use the correct trail types, objIDs and nodes for the intended purpose. 
     * 				This service does not create new nodes. Either use existing nodes or create new nodes in SIHOT.
     * 				This service includes information found in:
     * 				
     * 				S_EVENT_RESERVATION_TRAIL_NODE_GET_V001
     * 				S_GUEST_TRAIL_NODE_GET_V001 (for trailType, Node1Type and Node2Type)
     * 				S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001 (for objIDs of event information, service reservation, module reservation, room reservation, equipment reservation)
     * 				
     * 				
     * 			INPUT:
     * 				trailType	:	trail type e.g. 	Event (54000), Event Appointments(52000), Event Traces (53000), Guest  profile (12000)
     * 				Node1Type	:	type e.g event reservation(VANA), service reservation(LST), module reservation (MOR), room reservation (RAR), guest profile activity (0005) or to add trail (0000)
     * 				Node2Type	:	This node is responsible for creating a trail within a subtrail. See EXAMPLE 3
     * 				refObjID	:	objID of base node, e.g. event reservation ObjID or guest profile ObjID
     * 				refTreeObjID	:	When adding the new activity to the event, use the same as in the refObjID. 
     * 							Otherwise use the objID of the parent tree node in which the activity should be created (e.g. objID of the module reservation to create an activity in this module reservation).
     * 							see service S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001
     * 				parentRefObjID	:	Required for follow-up trails only (not related to the treeRefObjID!). ObjID of the master trail.
     * 							see service  S_EVENT_RESERVATION_TRAIL_NODE_GET_V001/S_GUEST_TRAIL_NODE_GET_V001
     * 				description	:	Description of the activity
     * 				status		:	combobox("ts") key value (can be defined in SIHOT)
     * 				beginDate	:	format: yyyy-mm-DD
     * 				beginTime	:	format: hh:mm
     * 				endDate		:	format: yyyy-mm-DD
     * 				endTime		:	format: hh:mm
     * 				user		:	SIHOT userID
     * 				comment			string comment 
     * 
     * 			OUTPUT:
     * 				ACTIVITY-OBJID:	ObjID of the newly created activity! If this field is empty or missing, the activity was not created (fail).			
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVITYADDV001Response
     */
    @WebMethod(operationName = "S_ACTIVITY_ADD_V001")
    @WebResult(name = "S_ACTIVITY_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVITYADDV001Response sACTIVITYADDV001(
        @WebParam(name = "S_ACTIVITY_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVITYADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service deletes an activity with a specific objID
     * 			
     * 			INPUT:
     * 				ACTIVITY-OBJID		:	Activity's ObjID  
     * 				
     * 
     * 			OUTPUT:
     * 				Empty			
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVITYREMOVEV001Response
     */
    @WebMethod(operationName = "S_ACTIVITY_REMOVE_V001")
    @WebResult(name = "S_ACTIVITY_REMOVE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVITYREMOVEV001Response sACTIVITYREMOVEV001(
        @WebParam(name = "S_ACTIVITY_REMOVE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVITYREMOVEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service delivers all activities with search parameter
     * 
     * 			INPUT:
     * 				hotels			: hotels the activitys/trails are in, field can be commaseparated for multiple select
     * 				user			: user id
     * 				trailType		: trailType from activity/trail. Have a look at the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.
     * 				activitytype		: Compare to "Node1Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.
     * 				activitysubtype		: Compare to "Node2Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.
     * 				refobjid		: ObjID of the referenced object (e.g. the ObjID of an event reservation).
     * 				datefrom		: If element is missing, then it's initialised with hoteldate. Send empty element for no validation.
     * 				dateto			: If element is missing, then it's initialised with hoteldate. Send empty element for no validation.
     * 				onlyOpen		: Searching for open activities only.
     * 
     * 			OUTPUT:
     * 				ACTIVITY-OBJID		: ObjID of the activity
     * 				user			: user id
     * 				status			: combobox("ts") key value (can be definied in SIHOT)
     * 				description		: description of the trail
     * 				appointmentdate		: format: yyyy-mm-DD
     * 				time			: format: hh:mm
     * 				endDate			: format: yyyy-mm-DD
     * 				endTime			: format: hh:mm
     * 				comment			: string comment 
     * 				refobjid		: ObjID of the referenced object
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVITYSEARCHV001Response
     */
    @WebMethod(operationName = "S_ACTIVITY_SEARCH_V001")
    @WebResult(name = "S_ACTIVITY_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVITYSEARCHV001Response sACTIVITYSEARCHV001(
        @WebParam(name = "S_ACTIVITY_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVITYSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service delivers all activities with search parameter
     * 
     * 			INPUT:
     * 				hotels		: hotels the activitys/trails are in, field can be commaseparated for multiple select
     * 				user		: user id
     * 				trailType	: trailType from activity/trail. Have a look at the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.
     * 				activitytype	: Compare to "Node1Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.
     * 				activitysubtype	: Compare to "Node2Type" in the result of service S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request.
     * 				refobjid	: ObjID of the referenced object (e.g. the ObjID of an event reservation).
     * 				datefrom	: If element is missing, then it's initialised with hoteldate. Send empty element for no validation.
     * 				dateto		: If element is missing, then it's initialised with hoteldate. Send empty element for no validation.
     * 				onlyOpen	: Searching for open activities only.
     * 
     * 			OUTPUT:
     * 				ACTIVITY-OBJID	: ObjID of the activity
     * 				user		: user id
     * 				status		: combobox("ts") key value (can be definied in SIHOT)
     * 				description	: description of the trail
     * 				appointmentdate	: format: yyyy-mm-DD
     * 				time		: format: hh:mm
     * 				endDate		: format: yyyy-mm-DD
     * 				endTime		: format: hh:mm
     * 				comment		: string comment 
     * 				refobjid	: ObjID of the referenced object
     * 				refTreeObjId	: objID refTree 
     * 				type		: string type of the trail 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVITYSEARCHV002Response
     */
    @WebMethod(operationName = "S_ACTIVITY_SEARCH_V002")
    @WebResult(name = "S_ACTIVITY_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVITYSEARCHV002Response sACTIVITYSEARCHV002(
        @WebParam(name = "S_ACTIVITY_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVITYSEARCHV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service shows all data of the requested activity
     * 
     * 			INPUT:
     * 				ACTIVITY-OBJID:	ObjID of the activity
     * 
     * 
     * 			OUTPUT:
     * 				description	:	description of the trail
     * 				status		:	combobox("ts") key value (can be definied in SIHOT)
     * 				beginDate	:	format: yyyy-mm-DD
     * 				beginTime	:	format: hh:mm
     * 				endDate		:	format: yyyy-mm-DD
     * 				endTime		:	format: hh:mm
     * 				user		:	sihot userID
     * 				comment		:	string comment 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVIYGETV001Response
     */
    @WebMethod(operationName = "S_ACTIVIY_GET_V001")
    @WebResult(name = "S_ACTIVIY_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVIYGETV001Response sACTIVIYGETV001(
        @WebParam(name = "S_ACTIVIY_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVIYGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service shows all data of the requested activity
     * 
     * 			INPUT:
     * 				ACTIVITY-OBJID:	ObjID of the activity
     * 				
     * 
     * 			OUTPUT:
     * 				description	:	description of the trail
     * 				status		:	combobox("ts") key value (can be definied in SIHOT)
     * 				beginDate	:	format: yyyy-mm-DD
     * 				beginTime	:	format: hh:mm
     * 				endDate		:	format: yyyy-mm-DD
     * 				endTime		:	format: hh:mm
     * 				user		:	sihot userID
     * 				comment		:	string comment 
     * 				refTreeObjId	:	objID refTree 
     * 				type		:	string type of the trail 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVIYGETV002Response
     */
    @WebMethod(operationName = "S_ACTIVIY_GET_V002")
    @WebResult(name = "S_ACTIVIY_GET_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVIYGETV002Response sACTIVIYGETV002(
        @WebParam(name = "S_ACTIVIY_GET_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVIYGETV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modifies the status of an activity.
     * 			INPUT:
     * 				ACTIVITY-OBJID:		ObjID from ACTIVITY
     * 				status		:	combobox("ts") key value (can be defined in SIHOT)
     * 
     * 			OUTPUT:
     * 				Empty
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVIYMODIFYSTATUSV001Response
     */
    @WebMethod(operationName = "S_ACTIVIY_MODIFY_STATUS_V001")
    @WebResult(name = "S_ACTIVIY_MODIFY_STATUS_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVIYMODIFYSTATUSV001Response sACTIVIYMODIFYSTATUSV001(
        @WebParam(name = "S_ACTIVIY_MODIFY_STATUS_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVIYMODIFYSTATUSV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modifies an activity.
     * 			
     * 				HINT: All fields needs to be send via service, because the activity will be changed with full update.
     * 			
     * 			INPUT:
     * 				ACTIVITY-OBJID:	ObjID from ACTIVITY
     * 				description:	description of the activity
     * 				status	:	combobox("ts") key value (can be defined in SIHOT)
     * 				beginDate:	format: yyyy-mm-DD
     * 				beginTime:	format: hh:mm
     * 				endDate	:	format: yyyy-mm-DD
     * 				endTime	:	format: hh:mm
     * 				user	:	sihot userID
     * 				comment	:	string comment 			
     * 
     * 			OUTPUT:
     * 				Empty
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SACTIVIYMODIFYV001Response
     */
    @WebMethod(operationName = "S_ACTIVIY_MODIFY_V001")
    @WebResult(name = "S_ACTIVIY_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SACTIVIYMODIFYV001Response sACTIVIYMODIFYV001(
        @WebParam(name = "S_ACTIVIY_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SACTIVIYMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service adds a settlement profile to a specific guest.
     * 
     * 			INPUT:
     * 				GUEST-OBJID:			ObjID of the guest, which can be obtained from defined services
     * 				or
     * 				GUEST-CENTRALID:		CentralID of the guest, which can be obtained from defined services
     * 				
     * 				SETTLEMENT-PROFILE-OBJID:	ObjID of the settlement profile guest, which can be obtained from defined services
     * 				or
     * 				SETTLEMENT-PROFILE-CENTRALID:	CentralID of the settlement profile guest, which can be obtained from defined services
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SADDSETTLEMENTPROFILEV001Response
     */
    @WebMethod(operationName = "S_ADD_SETTLEMENT_PROFILE_V001")
    @WebResult(name = "S_ADD_SETTLEMENT_PROFILE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SADDSETTLEMENTPROFILEV001Response sADDSETTLEMENTPROFILEV001(
        @WebParam(name = "S_ADD_SETTLEMENT_PROFILE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SADDSETTLEMENTPROFILEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns the forecast information of a specific allotment
     * 
     * 			INPUT:
     * 				ALLOTMENT-OBJID:	ObjID of the allotment, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				List of forecast entries
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTCONTRACTFORECASTGETV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_CONTRACTFORECAST_GET_V001")
    @WebResult(name = "S_ALLOTMENT_CONTRACTFORECAST_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTCONTRACTFORECASTGETV001Response sALLOTMENTCONTRACTFORECASTGETV001(
        @WebParam(name = "S_ALLOTMENT_CONTRACTFORECAST_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTCONTRACTFORECASTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns the allotment details (contract information) of a specific allotment
     * 
     * 			INPUT:
     * 				ALLOTMENT-OBJID:		ObjID of the allotment, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTDETAILSGETV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_DETAILS_GET_V001")
    @WebResult(name = "S_ALLOTMENT_DETAILS_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTDETAILSGETV001Response sALLOTMENTDETAILSGETV001(
        @WebParam(name = "S_ALLOTMENT_DETAILS_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTDETAILSGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns the external IDs of a specific allotment
     * 
     * 			INPUT:
     * 				ALLOTMENT-OBJID:		ObjID of the allotment, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				List of external IDs
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTEXTERNALIDSGETV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_EXTERNALIDS_GET_V001")
    @WebResult(name = "S_ALLOTMENT_EXTERNALIDS_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTEXTERNALIDSGETV001Response sALLOTMENTEXTERNALIDSGETV001(
        @WebParam(name = "S_ALLOTMENT_EXTERNALIDS_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTEXTERNALIDSGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns a specific allotment
     * 
     * 			INPUT:
     * 				ALLOTMENT-OBJID:	ObjID of the allotment, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				Allotment data
     * 			
     * 			GENERAL:
     * 				The term "Allotment" in SIHOT us used for:
     * 				- Allotments
     * 				- Groups Blocks
     * 			
     * 			REFERENCE:
     * 				A Allotment has some more details and a list of allotment details can be obtained with S_ALLOTMENT_DETAILS_GET_V...
     * 				A defintion of rates attached to the Allotment can be queried with S_ALLOTMENT_PACKAGES_GET_V...
     * 				To check restrictions you can use S_ALLOTMENT_RESTRICTIONS_GET_V...
     * 				Extrenal IDs can be attached to an allotment. Please refer to S_ALLOTMENT_EXTERNALIDS_GET_V...
     * 				If you want do create a reservation this is possible to ALLOTMENT-OBJID using services like 
     * 				To check rate information for an allotment you use S_RATE_SEARCH_V... and the the Input-Parameter: ALLOTMENT-OBJID
     * 				
     * 			
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTGETV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_GET_V001")
    @WebResult(name = "S_ALLOTMENT_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTGETV001Response sALLOTMENTGETV001(
        @WebParam(name = "S_ALLOTMENT_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns the packages of a specific allotment
     * 
     * 			INPUT:
     * 				ALLOTMENT-OBJID:		ObjID of the allotment, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				List of allotment packages
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTPACKAGESGETV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_PACKAGES_GET_V001")
    @WebResult(name = "S_ALLOTMENT_PACKAGES_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTPACKAGESGETV001Response sALLOTMENTPACKAGESGETV001(
        @WebParam(name = "S_ALLOTMENT_PACKAGES_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTPACKAGESGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns the restrictions of a specific allotment
     * 
     * 			INPUT:
     * 				ALLOTMENT-OBJID:		ObjID of the allotment, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				List of allotment restrictions
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTRESTRICTIONSGETV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_RESTRICTIONS_GET_V001")
    @WebResult(name = "S_ALLOTMENT_RESTRICTIONS_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTRESTRICTIONSGETV001Response sALLOTMENTRESTRICTIONSGETV001(
        @WebParam(name = "S_ALLOTMENT_RESTRICTIONS_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTRESTRICTIONSGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service can be used to search for allotment restrictions
     * 
     * 			INPUT (SEARCH CRITERIA):
     * 				ALLOTMENT-OBJID		(Optional)	ObjID of an allotment, which can be obtained from other defined services
     * 				dateFrom		(Optional)
     * 				dateTo			(Optional)
     * 				toBeSoldFrom		(Optional)
     * 				toBeSoldTo		(Optional)
     * 				
     * 			OUTPUT:
     * 				List of allotment restrictions matching the search criteria
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTRESTRICTIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_RESTRICTION_SEARCH_V001")
    @WebResult(name = "S_ALLOTMENT_RESTRICTION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTRESTRICTIONSEARCHV001Response sALLOTMENTRESTRICTIONSEARCHV001(
        @WebParam(name = "S_ALLOTMENT_RESTRICTION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTRESTRICTIONSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for allotments
     * 			
     * 			INPUT:
     * 				dateFrom
     * 				dateTo
     * 				status
     * 				allotmentType
     * 				category
     * 				allotment holder ...
     * 
     * 			OUTPUT:
     * 				List of allotments matching the request
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SALLOTMENTSEARCHV001Response
     */
    @WebMethod(operationName = "S_ALLOTMENT_SEARCH_V001")
    @WebResult(name = "S_ALLOTMENT_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SALLOTMENTSEARCHV001Response sALLOTMENTSEARCHV001(
        @WebParam(name = "S_ALLOTMENT_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SALLOTMENTSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				Search for arrivals for a specific day
     * 
     * 			INPUT:
     * 				arrival:		The date of arrival to search for arrivals on the given day
     * 				lastnamefirstname:	Lastname, firstname of the traveling guest
     * 				orderer:		Name of the orderer
     * 				marketsegment:		The market segment of the reservation
     * 				arrived:		Flag to search arrived or not arrived reservation. Possible values are 0 = not arrived yet; 1= already arrived -->
     * 				resno:			Search for certain reservation number (without reservation sub number)
     * 				gdsresnumber:		Search for certain GDS number
     * 				
     * 			OUTPUT:
     * 				The arrivals grouped by room and arriving Persons
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SARRIVALSEARCHV001Response
     */
    @WebMethod(operationName = "S_ARRIVAL_SEARCH_V001")
    @WebResult(name = "S_ARRIVAL_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SARRIVALSEARCHV001Response sARRIVALSEARCHV001(
        @WebParam(name = "S_ARRIVAL_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SARRIVALSEARCHV001Request body);

    /**
     * 
     * This service confirm an autotask
     * 
     * AutoTaskConfirm (Input)
     * 	AUTOTASK-OBJID (UnsignedInteger, ObjId)
     * 
     * <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:c="http://www.gubse.com/IFS/C_SAKUBA_CASH_REGISTER_SYSTEM_V001.xsd">
     *    <soapenv:Header/>
     *    <soapenv:Body>
     *       <c:S_AUTOTASK_CONFIRMATION_V001Request>
     *          <c:TransactionID></c:TransactionID>
     *          <c:Authentication>
     *             <c:SecurityID></c:SecurityID>
     *          </c:Authentication>
     *          <c:AutoTaskConfirm>
     *             <c:AUTOTASK-OBJID>32</c:AUTOTASK-OBJID>
     *          </c:AutoTaskConfirm>
     *       </c:S_AUTOTASK_CONFIRMATION_V001Request>
     *    </soapenv:Body>
     * </soapenv:Envelope>
     * 
     * 
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SAUTOTASKCONFIRMATIONV001Response
     */
    @WebMethod(operationName = "S_AUTOTASK_CONFIRMATION_V001")
    @WebResult(name = "S_AUTOTASK_CONFIRMATION_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SAUTOTASKCONFIRMATIONV001Response sAUTOTASKCONFIRMATIONV001(
        @WebParam(name = "S_AUTOTASK_CONFIRMATION_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SAUTOTASKCONFIRMATIONV001Request body);

    /**
     * 
     * This service sets an error for an autotask which is in execution.
     * 
     * AutoTaskSetError (Input)
     * 	AUTOTASK-OBJID (UnsignedInteger, ObjId)
     * 	ErrorMsg (string, Fehlertext)
     * 	SysMessage (Bool, Ampelmeldung erstellen) - [0, 1]
     * 
     * <soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:c="http://www.gubse.com/IFS/C_SAKUBA_CASH_REGISTER_SYSTEM_V001.xsd">
     *    <soapenv:Header/>
     *    <soapenv:Body>
     *       <c:S_AUTOTASK_SETERROR_V001Request>
     *          <!--Optional:-->
     *          <c:TransactionID></c:TransactionID>
     *          <c:Authentication>
     *             <c:SecurityID></c:SecurityID>
     *          </c:Authentication>
     *          <c:AutoTaskSetError>
     *             <c:AUTOTASK-OBJID>32</c:AUTOTASK-OBJID>
     *             <c:ErrorMsg>Error</c:ErrorMsg>
     *             <!--Optional:-->
     *             <c:SysMessage>1</c:SysMessage>
     *          </c:AutoTaskSetError>
     *       </c:S_AUTOTASK_SETERROR_V001Request>
     *    </soapenv:Body>
     * </soapenv:Envelope>
     * 
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SAUTOTASKSETERRORV001Response
     */
    @WebMethod(operationName = "S_AUTOTASK_SETERROR_V001")
    @WebResult(name = "S_AUTOTASK_SETERROR_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SAUTOTASKSETERRORV001Response sAUTOTASKSETERRORV001(
        @WebParam(name = "S_AUTOTASK_SETERROR_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SAUTOTASKSETERRORV001Request body);

    /**
     *  
     * 			GENERAL:
     * 				This service returns benchmark data. 
     * 			
     * 			INPUT:
     * 				Only the SecurityID must be specified.
     * 			
     * 			OUTPUT:
     * 				The service provides information about the speed of database accesses, memory utilisation, CPU utilisation, etc.
     * 			
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SBENCHMARKV001Response
     */
    @WebMethod(operationName = "S_BENCHMARK_V001")
    @WebResult(name = "S_BENCHMARK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SBENCHMARKV001Response sBENCHMARKV001(
        @WebParam(name = "S_BENCHMARK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SBENCHMARKV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service can be used to search for category restrictions
     * 
     * 			INPUT (SEARCH CRITERIA):
     * 				category		(Optional)
     * 				dateFrom		(Optional)
     * 				dateTo			(Optional)
     * 				toBeSoldFrom		(Optional)
     * 				toBeSoldTo		(Optional)
     * 				
     * 			OUTPUT:
     * 				List of category restrictions matching the search criteria
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SCATEGORYRESTRICTIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_CATEGORY_RESTRICTION_SEARCH_V001")
    @WebResult(name = "S_CATEGORY_RESTRICTION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SCATEGORYRESTRICTIONSEARCHV001Response sCATEGORYRESTRICTIONSEARCHV001(
        @WebParam(name = "S_CATEGORY_RESTRICTION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SCATEGORYRESTRICTIONSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for combobox entries by a specific type;
     * 				The entries can be optionally filtered by a specific language.
     * 
     * 			INPUT (searchcriteria): 
     * 				Type: 		Mandatory. The combobox type.
     * 				Language: 	Optional. Get the combobox entries in a specific language. If no language is given, the entries will be returned in all available languages.
     * 
     * 			OUTPUT:
     * 				Description: 	The name/description of the combobox.
     * 				Entries: 	Entries grouped by language
     * 					Language: The language of the Group
     * 					Entry: The list of combobox entries
     * 						Key: The unique identifier of the combobox entry.
     * 						Value: The text of the combobox entry.
     * 						Sorting: Display order of the combobox entry.
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SCOMBOBOXSEARCHV01Response
     */
    @WebMethod(operationName = "S_COMBOBOX_SEARCH_V01")
    @WebResult(name = "S_COMBOBOX_SEARCH_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SCOMBOBOXSEARCHV01Response sCOMBOBOXSEARCHV01(
        @WebParam(name = "S_COMBOBOX_SEARCH_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SCOMBOBOXSEARCHV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for combobox entries by a specific type;
     * 				The entries can be optionally filtered by a specific language.
     * 
     * 			INPUT (searchcriteria): 
     * 				Type: 		Mandatory. The combobox type.
     * 				Language: 	Optional. Get the combobox entries in a specific language. If no language is given, the entries will be returned in all available languages.
     * 
     * 			OUTPUT:
     * 				Description: 	The name/description of the combobox.
     * 				Entries: 	Entries grouped by language
     * 					Language: The language of the Group
     * 					Entry: The list of combobox entries
     * 						Key: The unique identifier of the combobox entry.
     * 						Value: The text of the combobox entry.
     * 						Sorting: Display order of the combobox entry.
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SCOMBOBOXSEARCHV02Response
     */
    @WebMethod(operationName = "S_COMBOBOX_SEARCH_V02")
    @WebResult(name = "S_COMBOBOX_SEARCH_V02Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SCOMBOBOXSEARCHV02Response sCOMBOBOXSEARCHV02(
        @WebParam(name = "S_COMBOBOX_SEARCH_V02Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SCOMBOBOXSEARCHV02Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service delivers the translations of descriptions and comments of the event module in all languages.
     * 			   
     * 			INPUT (searchcriteria): 
     * 				hotel 		: Hotel number
     * 				cbModuleId	: Id of event module
     * 			
     * 			OUTPUT:
     * 				List of description and comments with language code
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response
     */
    @WebMethod(operationName = "S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001")
    @WebResult(name = "S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response sEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001(
        @WebParam(name = "S_EVENT_CB_MODULE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTCBMODULEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service gives the translations of the description and comment from equipment.
     * 
     * 			INPUT (searchcriteria): 
     * 			-	equipmentNo
     * 			
     * 			OUTPUT:
     * 				List of description and comments with language code
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response
     */
    @WebMethod(operationName = "S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001")
    @WebResult(name = "S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response sEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV001(
        @WebParam(name = "S_EVENT_EQUIPMENT_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTEQUIPMENTMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service shows the objIDs of all room reservations, equipment reservations and module reservations of a specific event reservation
     * 			
     * 			INPUT:
     * 				EVENT-RESERVATION-OBJID:	ObjID of the event reservation
     * 				
     * 
     * 			OUTPUT:
     * 				Shows respective objIDs 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTRESERVATIONNODESTRUCTUREGETV001Response
     */
    @WebMethod(operationName = "S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001")
    @WebResult(name = "S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTRESERVATIONNODESTRUCTUREGETV001Response sEVENTRESERVATIONNODESTRUCTUREGETV001(
        @WebParam(name = "S_EVENT_RESERVATION_NODE_STRUCTURE_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTRESERVATIONNODESTRUCTUREGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service is able to add a service or a package to a particular event reservation or room reservation or module reservation. Also services to room reservations that are assigned to a module reservation can be added.
     * 
     * 			INPUT:
     * 				Due to that the service/package can be added to different nodes in the event tree, the necessary data needs to be sent to address the targeted node for the request. Use the refroomresobjid for room reservations and refmoduleresobjid for module reservations. If there are both empty, the service/package will be added to the event. If the room is below a module reservation, the refmoduleresobjid needs not to be sent. The room reservation is identifiable by its ObjID.
     * 				HINT: The ObjID of the event reservation is precondition for everything and needs to be set in all cases. And also the servicecode is required.
     * 				With the service the fromDate, toDate and also the timeFrom or timeTo as well as the numberliteral can be set. The service will create at least one data set per day between dateFrom and dateTo (inclusive). In case of assigning a package, there will be also one data set per entry in the components. If there are no data for the dates or times, the values of the superior node will be overtaken (Room in case of room services, module in case of module services and so on).
     * 
     * 			OUTPUT:
     * 				The service will return all services (no matter if they are standalone of from a package) that are assigned to that event reservation. The data are stored per date. And the result will be all the service entries of the event reservation, not only the recent created or assigned. The result set contains among other things the ObjID of every assigned service. The ObjID is necessary to change or remove the particular service afterwards.
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTRESERVATIONSERVICEADDV001Response
     */
    @WebMethod(operationName = "S_EVENT_RESERVATION_SERVICE_ADD_V001")
    @WebResult(name = "S_EVENT_RESERVATION_SERVICE_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTRESERVATIONSERVICEADDV001Response sEVENTRESERVATIONSERVICEADDV001(
        @WebParam(name = "S_EVENT_RESERVATION_SERVICE_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTRESERVATIONSERVICEADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service is able to modify a service or a package below a particular event reservation or room reservation or module reservation.
     * 
     * 				The service will change only the data at that day.
     * 				Changes can be made on time from, time to or numberliteral.
     * 			INPUT:
     * 			
     * 			OUTPUT:
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTRESERVATIONSERVICEMODIFYV001Response
     */
    @WebMethod(operationName = "S_EVENT_RESERVATION_SERVICE_MODIFY_V001")
    @WebResult(name = "S_EVENT_RESERVATION_SERVICE_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTRESERVATIONSERVICEMODIFYV001Response sEVENTRESERVATIONSERVICEMODIFYV001(
        @WebParam(name = "S_EVENT_RESERVATION_SERVICE_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTRESERVATIONSERVICEMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service is able to remove a service or a package below a particular event reservation or room reservation or module reservation.
     * 				The service will remove only the data at that day. If there is the request to reduce an assigned service, all the no longer used entries needs to be removed.
     * 
     * 			INPUT:
     * 
     * 			OUPUT:
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTRESERVATIONSERVICEREMOVEV001Response
     */
    @WebMethod(operationName = "S_EVENT_RESERVATION_SERVICE_REMOVE_V001")
    @WebResult(name = "S_EVENT_RESERVATION_SERVICE_REMOVE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTRESERVATIONSERVICEREMOVEV001Response sEVENTRESERVATIONSERVICEREMOVEV001(
        @WebParam(name = "S_EVENT_RESERVATION_SERVICE_REMOVE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTRESERVATIONSERVICEREMOVEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service get all trails with all data that are stored below an event reservation
     * 			
     * 			INPUT:
     * 				EVENT-RESERVATION-OBJID:	ObjID of the event reservation
     * 				
     * 
     * 			OUTPUT:
     * 				Node1Type:	The first node from trail structure. Value is always 4 characters long -> e.g. 0000.
     * 				Node2Type:	Increasing number below the NodeType (0000, 0001, 0002 and so on...)
     * 				description:	description from trail	
     * 				status	:	combobox("ts") key value
     * 				beginDate:	format: yyyy-mm-DD
     * 				beginTime:	format: hh:mm
     * 				endDate	:	format: yyyy-mm-DD
     * 				endTime	:	format: hh:mm
     * 				user	:	sihot userID
     * 				comment	:	string comment 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTRESERVATIONTRAILNODEGETV001Response
     */
    @WebMethod(operationName = "S_EVENT_RESERVATION_TRAIL_NODE_GET_V001")
    @WebResult(name = "S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTRESERVATIONTRAILNODEGETV001Response sEVENTRESERVATIONTRAILNODEGETV001(
        @WebParam(name = "S_EVENT_RESERVATION_TRAIL_NODE_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTRESERVATIONTRAILNODEGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service transfers an event reservation to another begin.
     * 
     * 			INPUT:
     * 				EVENT-RESERVATION-OBJID: of the event reservation requested to transfer.
     * 				transferreservations:	0 -> FO reserations with the same begin as the event were transfered
     * 							1 -> all FO reservations (no further condition check) were transfered
     * 							2 -> no FO reservations were transfered
     * 
     * 			OUTPUT:
     * 				The service returns the new dateFrom and dateTo
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTRESERVATIONTRANSFERV001Response
     */
    @WebMethod(operationName = "S_EVENT_RESERVATION_TRANSFER_V001")
    @WebResult(name = "S_EVENT_RESERVATION_TRANSFER_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTRESERVATIONTRANSFERV001Response sEVENTRESERVATIONTRANSFERV001(
        @WebParam(name = "S_EVENT_RESERVATION_TRANSFER_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTRESERVATIONTRANSFERV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service gives the translations of the description and comment from event rooms.
     * 			   
     * 			INPUT (searchcriteria): 
     * 				eventRoom
     * 			
     * 			OUTPUT:
     * 				List of description and comments with language code
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response
     */
    @WebMethod(operationName = "S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001")
    @WebResult(name = "S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response sEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV001(
        @WebParam(name = "S_EVENT_ROOM_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SEVENTROOMMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for free rooms
     * 
     * 			INPUT:
     * 				datefrom:		start date from when the room must be vacant 		Optional
     * 				dateto:			end date from when the room must be vacant		Optional
     * 				category:		room category, combobox key				Optional
     * 				roomfrom:		start room number					Optional
     * 				roomto:			end room number						Optional
     * 
     * 			OUTPUT:
     * 				List of free rooms matching the request
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SFREEROOMSEARCHV001Response
     */
    @WebMethod(operationName = "S_FREE_ROOM_SEARCH_V001")
    @WebResult(name = "S_FREE_ROOM_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SFREEROOMSEARCHV001Response sFREEROOMSEARCHV001(
        @WebParam(name = "S_FREE_ROOM_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SFREEROOMSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service adds a settlement profile to a specific guest.
     * 
     * 			INPUT:
     * 				GUEST-OBJID:			ObjID of the guest, which can be obtained from defined services
     * 				or
     * 				GUEST-CENTRALID:		CentralID of the guest, which can be obtained from defined services
     * 
     * 			OUPUT:
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGETGUESTHIERARCHYV001Response
     */
    @WebMethod(operationName = "S_GET_GUEST_HIERARCHY_V001")
    @WebResult(name = "S_GET_GUEST_HIERARCHY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGETGUESTHIERARCHYV001Response sGETGUESTHIERARCHYV001(
        @WebParam(name = "S_GET_GUEST_HIERARCHY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGETGUESTHIERARCHYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service gets settlement profiles from a specific guest.
     * 
     * 			INPUT:
     * 				GUEST-OBJID:			ObjID of the guest, which can be obtained from defined services
     * 				or
     * 				GUEST-CENTRALID:		CentralID of the guest, which can be obtained from defined services
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGETSETTLEMENTPROFILEV001Response
     */
    @WebMethod(operationName = "S_GET_SETTLEMENT_PROFILE_V001")
    @WebResult(name = "S_GET_SETTLEMENT_PROFILE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGETSETTLEMENTPROFILEV001Response sGETSETTLEMENTPROFILEV001(
        @WebParam(name = "S_GET_SETTLEMENT_PROFILE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGETSETTLEMENTPROFILEV001Request body);

    /**
     *  
     * 			GENERAL:
     * 				This service returns information about the current user and current hotel, which is determined by the specified SecurityID. 
     * 			
     * 			INPUT:
     * 				Only the SecurityID must be specified.
     * 			
     * 			OUTPUT:
     * 				The service will return informationen about the current user and current hotel.
     * 			
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGETUSERINFOV001Response
     */
    @WebMethod(operationName = "S_GET_USER_INFO_V001")
    @WebResult(name = "S_GET_USER_INFO_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGETUSERINFOV001Response sGETUSERINFOV001(
        @WebParam(name = "S_GET_USER_INFO_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGETUSERINFOV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for gift vouchers:
     * 		       
     * 			INPUT (searchcriteria): 
     * 				sellDate (compulusory)
     * 				sellTo: Period of sell date 
     * 				giftVoucherNoFrom
     * 				giftVoucherNoTo: gift voucher number
     * 				externalReference
     * 				blocked, all, open: gift voucher state; only one field may be set with 1
     * 				holderName
     * 				redemptionDate
     * 				redemptionDateTo: gift voucher redemption date
     * 				hotelSell
     * 			
     * 			OUTPUT:
     * 				List of gift vouchers
     * 				
     * 				objid: unique id
     * 				status: 1 = valid, 2 = not valid, 3 = redeemed, 4 = invoiced, 5 = suspended, 6 = incomplete, 7 = unavailable
     * 				number, externalReference
     * 				amount
     * 				sellDate, hotelSell, expiryDate
     * 				gift voucher holder:
     * 				
     * 				GiftvoucherHolder ->
     * 					objid
     * 					lastName
     * 					matchcode
     * 					guestHotel
     * 					guestNo
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGIFTVOUCHERSEARCHV002Response
     */
    @WebMethod(operationName = "S_GIFT_VOUCHER_SEARCH_V002")
    @WebResult(name = "S_GIFT_VOUCHER_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGIFTVOUCHERSEARCHV002Response sGIFTVOUCHERSEARCHV002(
        @WebParam(name = "S_GIFT_VOUCHER_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGIFTVOUCHERSEARCHV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service return a specific account
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOACCOUNTV001Response
     */
    @WebMethod(operationName = "S_GO_ACCOUNT_V001")
    @WebResult(name = "S_GO_ACCOUNT_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOACCOUNTV001Response sGOACCOUNTV001(
        @WebParam(name = "S_GO_ACCOUNT_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOACCOUNTV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for combobox entries by a specific type;
     * 				The entries can be optionally filtered by a specific language.
     * 
     * 			INPUT (searchcriteria): 
     * 				Type: 		Mandatory. The combobox type.
     * 				Language: 	Optional. Get the combobox entries in a specific language. If no language is given, the entries will be returned in all available languages.
     * 
     * 			OUTPUT:
     * 				Description: 	The name/description of the combobox.
     * 				Entries: 	Entries grouped by language
     * 					Language: The language of the Group
     * 					Entry: The list of combobox entries
     * 						Key: The unique identifier of the combobox entry.
     * 						Value: The text of the combobox entry.
     * 						Sorting: Display order of the combobox entry.
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOCOMBOBOXSEARCHV001Response
     */
    @WebMethod(operationName = "S_GO_COMBOBOX_SEARCH_V001")
    @WebResult(name = "S_GO_COMBOBOX_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOCOMBOBOXSEARCHV001Response sGOCOMBOBOXSEARCHV001(
        @WebParam(name = "S_GO_COMBOBOX_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOCOMBOBOXSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns registry data
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOCONFIGV001Response
     */
    @WebMethod(operationName = "S_GO_CONFIG_V001")
    @WebResult(name = "S_GO_CONFIG_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOCONFIGV001Response sGOCONFIGV001(
        @WebParam(name = "S_GO_CONFIG_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOCONFIGV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service creates a ExternalID for a guest (GST).
     * 
     * 			INPUT:
     * 				GST-OBJID:	ObjID of the gst, which can be obtained from defined services			Mandatory
     * 				data for the ExternalID to be added
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOGSTEXTERNALIDADDV001Response
     */
    @WebMethod(operationName = "S_GO_GST_EXTERNALID_ADD_V001")
    @WebResult(name = "S_GO_GST_EXTERNALID_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOGSTEXTERNALIDADDV001Response sGOGSTEXTERNALIDADDV001(
        @WebParam(name = "S_GO_GST_EXTERNALID_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOGSTEXTERNALIDADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service deletes na ExternalID from a guest (GST).
     * 
     * 			INPUT:
     * 				GST-OBJID:	ObjID of the GST, which can be obtained from defined services			Mandatory
     * 				type of the ExternalID to be deleted
     * 			OUTPUT:
     * 				returns the updated gst's ExternalIDs (after the deletion)
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOGSTEXTERNALIDDELETEV001Response
     */
    @WebMethod(operationName = "S_GO_GST_EXTERNALID_DELETE_V001")
    @WebResult(name = "S_GO_GST_EXTERNALID_DELETE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOGSTEXTERNALIDDELETEV001Response sGOGSTEXTERNALIDDELETEV001(
        @WebParam(name = "S_GO_GST_EXTERNALID_DELETE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOGSTEXTERNALIDDELETEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returne all hotels in the systen; the field DUMMY_INTERNAL is only for internal use must be set to 0
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOHOTELSEARCHV001Response
     */
    @WebMethod(operationName = "S_GO_HOTEL_SEARCH_V001")
    @WebResult(name = "S_GO_HOTEL_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOHOTELSEARCHV001Response sGOHOTELSEARCHV001(
        @WebParam(name = "S_GO_HOTEL_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOHOTELSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns detail information specific hotel with objID HOTEL-OBJID
     * 			
     * 			INPUT:
     * 				objID of the hotel
     * 			
     * 			OUTPUT:
     * 				hotel's information and also the first hotel's image which description is 'SIHOT.GO', if it exists
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOHOTELV001Response
     */
    @WebMethod(operationName = "S_GO_HOTEL_V001")
    @WebResult(name = "S_GO_HOTEL_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOHOTELV001Response sGOHOTELV001(
        @WebParam(name = "S_GO_HOTEL_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOHOTELV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service creates a ExternalID for a person (GRP).
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 				data for the ExternalID to be added
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPERSONEXTERNALIDADDV001Response
     */
    @WebMethod(operationName = "S_GO_PERSON_EXTERNALID_ADD_V001")
    @WebResult(name = "S_GO_PERSON_EXTERNALID_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPERSONEXTERNALIDADDV001Response sGOPERSONEXTERNALIDADDV001(
        @WebParam(name = "S_GO_PERSON_EXTERNALID_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPERSONEXTERNALIDADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service deletes na ExternalID from a person (GRP).
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 				type of the ExternalID to be deleted
     * 			OUTPUT:
     * 				returns the updated person's ExternalIDs (after the deletion)
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPERSONEXTERNALIDDELETEV001Response
     */
    @WebMethod(operationName = "S_GO_PERSON_EXTERNALID_DELETE_V001")
    @WebResult(name = "S_GO_PERSON_EXTERNALID_DELETE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPERSONEXTERNALIDDELETEV001Response sGOPERSONEXTERNALIDDELETEV001(
        @WebParam(name = "S_GO_PERSON_EXTERNALID_DELETE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPERSONEXTERNALIDDELETEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service submits (adds) the feedback from a person (GRP).
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPERSONFEEDBACKADDV001Response
     */
    @WebMethod(operationName = "S_GO_PERSON_FEEDBACK_ADD_V001")
    @WebResult(name = "S_GO_PERSON_FEEDBACK_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPERSONFEEDBACKADDV001Response sGOPERSONFEEDBACKADDV001(
        @WebParam(name = "S_GO_PERSON_FEEDBACK_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPERSONFEEDBACKADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service reads the feedback.
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 			OUTPUT:
     * 				returns the person's feedbacks, if any
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPERSONFEEDBACKV001Response
     */
    @WebMethod(operationName = "S_GO_PERSON_FEEDBACK_V001")
    @WebResult(name = "S_GO_PERSON_FEEDBACK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPERSONFEEDBACKV001Response sGOPERSONFEEDBACKV001(
        @WebParam(name = "S_GO_PERSON_FEEDBACK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPERSONFEEDBACKV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guests (BO_Person) assigned to reservations
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPERSONLOADV001Response
     */
    @WebMethod(operationName = "S_GO_PERSON_LOAD_V001")
    @WebResult(name = "S_GO_PERSON_LOAD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPERSONLOADV001Response sGOPERSONLOADV001(
        @WebParam(name = "S_GO_PERSON_LOAD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPERSONLOADV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modify a person.
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 				All data to be changed
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPERSONMODIFYV001Response
     */
    @WebMethod(operationName = "S_GO_PERSON_MODIFY_V001")
    @WebResult(name = "S_GO_PERSON_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPERSONMODIFYV001Response sGOPERSONMODIFYV001(
        @WebParam(name = "S_GO_PERSON_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPERSONMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guests (BO_Person) assigned to reservations
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPERSONSEARCHV001Response
     */
    @WebMethod(operationName = "S_GO_PERSON_SEARCH_V001")
    @WebResult(name = "S_GO_PERSON_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPERSONSEARCHV001Response sGOPERSONSEARCHV001(
        @WebParam(name = "S_GO_PERSON_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPERSONSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns a reservation's pre-payment data.
     * 				
     * 			INPUT:
     * 				RESERVATION-OBJID
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGOPOSTPREPAYMENTV001Response
     */
    @WebMethod(operationName = "S_GO_POSTPREPAYMENT_V001")
    @WebResult(name = "S_GO_POSTPREPAYMENT_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGOPOSTPREPAYMENTV001Response sGOPOSTPREPAYMENTV001(
        @WebParam(name = "S_GO_POSTPREPAYMENT_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGOPOSTPREPAYMENTV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for reservations
     * 
     * 			INPUT:
     * 				kiosksearch:		reservation number							Optional
     * 				name1:			Name of the booker with "startsWith" matching				Optional
     * 				resnofrom:		start reservation number						Optional
     * 				resnoto:		end reservation number							Optional
     * 				gdsresnumber:		GDS number of the reservation						Optional
     * 				arrival:		arrival date of the reservation						Optional
     * 				departure:		departure date of the reservation					Optional
     * 				findPersons:		"name1" will also match with persons not just the reservation owner	Optional
     * 
     * 			OUTPUT:
     * 				List of reservation matching the request
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGORESERVATIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_GO_RESERVATION_SEARCH_V001")
    @WebResult(name = "S_GO_RESERVATION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGORESERVATIONSEARCHV001Response sGORESERVATIONSEARCHV001(
        @WebParam(name = "S_GO_RESERVATION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGORESERVATIONSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service return a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				reservation  data
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGORESERVATIONV001Response
     */
    @WebMethod(operationName = "S_GO_RESERVATION_V001")
    @WebResult(name = "S_GO_RESERVATION_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGORESERVATIONV001Response sGORESERVATIONV001(
        @WebParam(name = "S_GO_RESERVATION_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGORESERVATIONV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns all contact persons of a specific guest profile
     * 				!! This profile needs to be a profile of a legal entity, like company, tour operator, agency ...			
     * 
     * 			INPUT:
     * 				GUEST-OBJID:		ObjID of the guest, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				List of contact persons
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTCONTACTPERSONSGETV001Response
     */
    @WebMethod(operationName = "S_GUEST_CONTACT_PERSONS_GET_V001")
    @WebResult(name = "S_GUEST_CONTACT_PERSONS_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTCONTACTPERSONSGETV001Response sGUESTCONTACTPERSONSGETV001(
        @WebParam(name = "S_GUEST_CONTACT_PERSONS_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTCONTACTPERSONSGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service creates a new guest profile
     * 
     * 			INPUT:
     * 				Guest data
     * 
     * 			OUTPUT:
     * 				GUEST-OBJID:		ObjID of the newly created guest profile
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTCREATEV001Response
     */
    @WebMethod(operationName = "S_GUEST_CREATE_V001")
    @WebResult(name = "S_GUEST_CREATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTCREATEV001Response sGUESTCREATEV001(
        @WebParam(name = "S_GUEST_CREATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTCREATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service creates a new guest profile
     * 
     * 			INPUT:
     * 				Guest data
     * 
     * 			OUTPUT:
     * 				GUEST-OBJID:		ObjID of the newly created guest profile
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTCREATEV002Response
     */
    @WebMethod(operationName = "S_GUEST_CREATE_V002")
    @WebResult(name = "S_GUEST_CREATE_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTCREATEV002Response sGUESTCREATEV002(
        @WebParam(name = "S_GUEST_CREATE_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTCREATEV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				Returns all available guest criteria
     * 
     * 			INPUT:
     * 				None
     * 				
     * 			OUTPUT:
     * 				The guest Criteria
     * 				
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTCRITERIAGETV001Response
     */
    @WebMethod(operationName = "S_GUEST_CRITERIA_GET_V001")
    @WebResult(name = "S_GUEST_CRITERIA_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTCRITERIAGETV001Response sGUESTCRITERIAGETV001(
        @WebParam(name = "S_GUEST_CRITERIA_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTCRITERIAGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				Modify a guest criteria from a specific guest
     * 
     * 			INPUT:
     * 				GUEST-OBJID:			ObjID of the guest, which can be obtained from defined services
     * 				or
     * 				GUEST-CENTR	ALID:		CentralID of the guest, which can be obtained from defined services
     * 
     * 			OUPUT:
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTCRITERIAMODIFYV001Response
     */
    @WebMethod(operationName = "S_GUEST_CRITERIA_MODIFY_V001")
    @WebResult(name = "S_GUEST_CRITERIA_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTCRITERIAMODIFYV001Response sGUESTCRITERIAMODIFYV001(
        @WebParam(name = "S_GUEST_CRITERIA_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTCRITERIAMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				Returns guests by guest criteria
     * 
     * 			INPUT:
     * 				SearchCriteria:		Mandatory
     * 					TYPE:		Type of the guest criteria to search for	Mandatory
     * 					SUBTYPE:	SubType of the guest criteria to search for
     * 					
     * 				SearchCriteria1:	Optional
     * 					TYPE:		Type of the guest criteria to search for
     * 					SUBTYPE:	SubType of the guest criteria to search for
     * 					
     * 				SearchCriteria2:	Optional
     * 					TYPE:		Type of the guest criteria to search for	
     * 					SUBTYPE:	SubType of the guest criteria to search for
     * 			OUTPUT:
     * 				The guest Criteria
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTCRITERIASEARCHV001Response
     */
    @WebMethod(operationName = "S_GUEST_CRITERIA_SEARCH_V001")
    @WebResult(name = "S_GUEST_CRITERIA_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTCRITERIASEARCHV001Response sGUESTCRITERIASEARCHV001(
        @WebParam(name = "S_GUEST_CRITERIA_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTCRITERIASEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service gets a guest profile by objID
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTGETV001Response
     */
    @WebMethod(operationName = "S_GUEST_GET_V001")
    @WebResult(name = "S_GUEST_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTGETV001Response sGUESTGETV001(
        @WebParam(name = "S_GUEST_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns a specific guest
     * 
     * 			INPUT:
     * 				GUEST-OBJID:		ObjID of the guest, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				Guest data
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTGETV002Response
     */
    @WebMethod(operationName = "S_GUEST_GET_V002")
    @WebResult(name = "S_GUEST_GET_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTGETV002Response sGUESTGETV002(
        @WebParam(name = "S_GUEST_GET_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTGETV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guest in house
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTINHOUSESEARCHV001Response
     */
    @WebMethod(operationName = "S_GUEST_IN_HOUSE_SEARCH_V001")
    @WebResult(name = "S_GUEST_IN_HOUSE_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTINHOUSESEARCHV001Response sGUESTINHOUSESEARCHV001(
        @WebParam(name = "S_GUEST_IN_HOUSE_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTINHOUSESEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guests in house
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTINHOUSESEARCHV002Response
     */
    @WebMethod(operationName = "S_GUEST_IN_HOUSE_SEARCH_V002")
    @WebResult(name = "S_GUEST_IN_HOUSE_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTINHOUSESEARCHV002Response sGUESTINHOUSESEARCHV002(
        @WebParam(name = "S_GUEST_IN_HOUSE_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTINHOUSESEARCHV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modify a specific guest.
     * 
     * 			INPUT:
     * 				GUEST-OBJID:	ObjID of the guest, which can be obtained from defined services			Mandatory
     * 				- All data to be changed
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTMODIFYV001Response
     */
    @WebMethod(operationName = "S_GUEST_MODIFY_V001")
    @WebResult(name = "S_GUEST_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTMODIFYV001Response sGUESTMODIFYV001(
        @WebParam(name = "S_GUEST_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modify a specific guest.
     * 
     * 			INPUT:
     * 				GUEST-OBJID:		ObjID of the guest, which can be obtained from defined services			Mandatory
     * 				GUEST-CENTRALID:	Central ID of the guest, which can be obtained from defined services		Mandatory
     * 				- All data to be changed
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTMODIFYV002Response
     */
    @WebMethod(operationName = "S_GUEST_MODIFY_V002")
    @WebResult(name = "S_GUEST_MODIFY_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTMODIFYV002Response sGUESTMODIFYV002(
        @WebParam(name = "S_GUEST_MODIFY_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTMODIFYV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modifies a specific guest
     * 
     * 			INPUT:
     * 				GUEST-OBJID:		ObjID of the guest, which can be obtained from other defined services	
     * 				GUEST-CENTRALID:	Central ID of the guest, which can be obtained from other defined services
     * 				
     * 				(either GUEST-OBJID or GUEST-CENTRALID is required for loading the profile)
     * 				
     * 				All data to be changed
     * 
     * 			OUTPUT:
     * 				Empty: only result tag
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTMODIFYV003Response
     */
    @WebMethod(operationName = "S_GUEST_MODIFY_V003")
    @WebResult(name = "S_GUEST_MODIFY_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTMODIFYV003Response sGUESTMODIFYV003(
        @WebParam(name = "S_GUEST_MODIFY_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTMODIFYV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modifies a specific guest
     * 
     * 			INPUT:
     * 				GUEST-OBJID:		ObjID of the guest, which can be obtained from other defined services	
     * 				GUEST-CENTRALID:	Central ID of the guest, which can be obtained from other defined services
     * 				
     * 				(either GUEST-OBJID or GUEST-CENTRALID is required for loading the profile)
     * 				
     * 				All data to be changed
     * 
     * 			OUTPUT:
     * 				Empty: only result tag
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTMODIFYV004Response
     */
    @WebMethod(operationName = "S_GUEST_MODIFY_V004")
    @WebResult(name = "S_GUEST_MODIFY_V004Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTMODIFYV004Response sGUESTMODIFYV004(
        @WebParam(name = "S_GUEST_MODIFY_V004Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTMODIFYV004Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guests:
     * 		
     * 			INPUT (searchcriteria): 
     * 				lastName, 
     * 				firstName, 
     * 				matchcode
     * 				guestType: 0 = accompaniment, 1= guest, 2 = company, 3 = agency, 4 = sales office, 5 = co-operation partner, 6 = affiliated company, 7 = tour operator
     * 				coutnry, 
     * 				city, 
     * 				postCode, 
     * 				street
     * 				email, 
     * 				guestNo, 
     * 				identificationNo, 
     * 				centralID (only available in central systems)
     * 			
     * 			OUTPUT:
     * 				List of guests (see searchcriteria)
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTSEARCHV002Response
     */
    @WebMethod(operationName = "S_GUEST_SEARCH_V002")
    @WebResult(name = "S_GUEST_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTSEARCHV002Response sGUESTSEARCHV002(
        @WebParam(name = "S_GUEST_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTSEARCHV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guests:
     * 		
     * 			INPUT (searchcriteria): 
     * 				lastName, 
     * 				firstName, 
     * 				matchcode
     * 				guestType: 0 = accompaniment, 1= guest, 2 = company, 3 = agency, 4 = sales office, 5 = co-operation partner, 6 = affiliated company, 7 = tour operator
     * 				coutnry, 
     * 				city, 
     * 				postCode, 
     * 				street
     * 				email, 
     * 				guestNo, 
     * 				identificationNo, 
     * 				centralID (only available in central systems)
     * 			
     * 			OUTPUT:
     * 				List of guests (see searchcriteria)
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTSEARCHV003Response
     */
    @WebMethod(operationName = "S_GUEST_SEARCH_V003")
    @WebResult(name = "S_GUEST_SEARCH_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTSEARCHV003Response sGUESTSEARCHV003(
        @WebParam(name = "S_GUEST_SEARCH_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTSEARCHV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guests. guests can be legal entities (e.g. company, tour operator) or private persons
     * 		
     * 			INPUT (searchcriteria): 
     * 				lastName, 
     * 				firstName, 
     * 				matchcode
     * 				guestType: 0 = accompaniment, 1= guest, 2 = company, 3 = agency, 4 = sales office, 5 = co-operation partner, 6 = affiliated company, 7 = tour operator
     * 				coutnry, 
     * 				city, 
     * 				postCode, 
     * 				street
     * 				email, 
     * 				guestNo, 
     * 				identificationNo, 
     * 				centralID (only available in central systems)
     * 			
     * 			OUTPUT:
     * 				List of guests (see searchcriteria)		
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTSEARCHV004Response
     */
    @WebMethod(operationName = "S_GUEST_SEARCH_V004")
    @WebResult(name = "S_GUEST_SEARCH_V004Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTSEARCHV004Response sGUESTSEARCHV004(
        @WebParam(name = "S_GUEST_SEARCH_V004Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTSEARCHV004Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for guests. guests can be legal entities (e.g. company, tour operator) or private persons
     * 		
     * 			INPUT (searchcriteria): 
     * 				lastName, 
     * 				firstName, 
     * 				matchcode
     * 				guestType: 0 = accompaniment, 1= guest, 2 = company, 3 = agency, 4 = sales office, 5 = co-operation partner, 6 = affiliated company, 7 = tour operator
     * 				coutnry, 
     * 				city, 
     * 				postCode, 
     * 				street
     * 				email, 
     * 				guestNo, 
     * 				identificationNo, 
     * 				centralID (only available in central systems)
     * 			
     * 			OUTPUT:
     * 				List of guests (see searchcriteria)		
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTSEARCHV005Response
     */
    @WebMethod(operationName = "S_GUEST_SEARCH_V005")
    @WebResult(name = "S_GUEST_SEARCH_V005Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTSEARCHV005Response sGUESTSEARCHV005(
        @WebParam(name = "S_GUEST_SEARCH_V005Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTSEARCHV005Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service gets all trails from guest profile
     * 			
     * 			INPUT:
     * 				GUEST-OBJID:	ObjID of the guest profile
     * 				
     * 
     * 			OUTPUT:
     * 				Node1Type:	The first node from trail structure. values only 4 characters long numbers -> e.g. 0000.
     * 				Node2Type:	Increasing number below the NodeType (0000, 0001, 0002 and so on...)
     * 				description:	description of the trail
     * 				status	:	combobox("ts") key value (can be defined in SIHOT)
     * 				beginDate:	format: yyyy-mm-DD
     * 				beginTime:	format: hh:mm
     * 				endDate	:	format: yyyy-mm-DD
     * 				endTime	:	format: hh:mm
     * 				user	:	sihot userID
     * 				comment	:	string comment 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SGUESTTRAILNODEGETV001Response
     */
    @WebMethod(operationName = "S_GUEST_TRAIL_NODE_GET_V001")
    @WebResult(name = "S_GUEST_TRAIL_NODE_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SGUESTTRAILNODEGETV001Response sGUESTTRAILNODEGETV001(
        @WebParam(name = "S_GUEST_TRAIL_NODE_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SGUESTTRAILNODEGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service can be used to search for hotel restrictions
     * 
     * 			INPUT (SEARCH CRITERIA):
     * 				dateFrom		(Optional)
     * 				dateTo			(Optional)
     * 				toBeSoldFrom		(Optional)
     * 				toBeSoldTo		(Optional)
     * 				
     * 			OUTPUT:
     * 				List of hotel restrictions matching the search criteria
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SHOTELRESTRICTIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_HOTEL_RESTRICTION_SEARCH_V001")
    @WebResult(name = "S_HOTEL_RESTRICTION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SHOTELRESTRICTIONSEARCHV001Response sHOTELRESTRICTIONSEARCHV001(
        @WebParam(name = "S_HOTEL_RESTRICTION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SHOTELRESTRICTIONSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returne all hotels in the systen; the field DUMMY_INTERNAL is only for internal use must be set to 0
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SHOTELSEARCHV01Response
     */
    @WebMethod(operationName = "S_HOTEL_SEARCH_V01")
    @WebResult(name = "S_HOTEL_SEARCH_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SHOTELSEARCHV01Response sHOTELSEARCHV01(
        @WebParam(name = "S_HOTEL_SEARCH_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SHOTELSEARCHV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns a specific hotel with objID HOTEL-OBJID
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SHOTELV001Response
     */
    @WebMethod(operationName = "S_HOTEL_V001")
    @WebResult(name = "S_HOTEL_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SHOTELV001Response sHOTELV001(
        @WebParam(name = "S_HOTEL_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SHOTELV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service Add images to a specific table and object
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SIMAGESADDV001Response
     */
    @WebMethod(operationName = "S_IMAGES_ADD_V001")
    @WebResult(name = "S_IMAGES_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SIMAGESADDV001Response sIMAGESADDV001(
        @WebParam(name = "S_IMAGES_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SIMAGESADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for packages
     * 
     * 			INPUT:
     * 				servicecode:	service code, combobox key			Optional
     * 				servicetype:	service type, combobox key			Optional
     * 				ratefilter:	rate filter, combobox key			Optional
     * 				ratesegment:	ratesegment, combobox key			Optional
     * 				dateforprice:	date for calculate rate				Optional
     * 
     * 			OUTPUT:
     * 				List of packages matching the request
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPACKAGESSEARCHV001Response
     */
    @WebMethod(operationName = "S_PACKAGES_SEARCH_V001")
    @WebResult(name = "S_PACKAGES_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPACKAGESSEARCHV001Response sPACKAGESSEARCHV001(
        @WebParam(name = "S_PACKAGES_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPACKAGESSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for packages
     * 
     * 			INPUT:
     * 				servicecode:	service code, combobox key			Optional
     * 				servicetype:	service type, combobox key			Optional
     * 				ratefilter:	rate filter, combobox key			Optional
     * 				ratesegment:	ratesegment, combobox key			Optional
     * 				dateforprice:	date for calculate rate				Optional
     * 
     * 			OUTPUT:
     * 				List of packages matching the request
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPACKAGESSEARCHV002Response
     */
    @WebMethod(operationName = "S_PACKAGES_SEARCH_V002")
    @WebResult(name = "S_PACKAGES_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPACKAGESSEARCHV002Response sPACKAGESSEARCHV002(
        @WebParam(name = "S_PACKAGES_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPACKAGESSEARCHV002Request body);

    /**
     * 
     * 		GENERAL:
     * 			This service gives the descriptions and comments in all languages of packages
     * 	       
     * 		INPUT (searchcriteria): 
     * 			packageCode
     * 		
     * 		OUTPUT:
     * 			List of description and comments with language code
     * 			rateSegment is a combobox "PS"
     * 	
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response
     */
    @WebMethod(operationName = "S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001")
    @WebResult(name = "S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response sPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001(
        @WebParam(name = "S_PACKAGE_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPACKAGEMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service adds a service with manual rate on a specific person
     * 
     * 			INPUT:
     * 				PERSON-OBJID:		ObjID of the person, which can be obtained from defined services			Mandatory
     * 				servicecode:		service code, combobox key, which can be obtained from defined services			Mandatory
     * 				datefrom:		start date for the service								Mandatory
     * 				dateto:			end date for the service								Mandatory
     * 				ratecategory:		rate category, combobox key								Optional
     * 				pricesegment:		price segement, combobox key								Optional
     * 				quantity:		quantity										Optional
     * 				manualrate:		price per unit per day									Optional
     * 				discountgroup:		discount group, combobox key								Optional
     * 				currency:		currency, combobox key									Optional
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPERSONADDSERVICEMANUALRATEV001Response
     */
    @WebMethod(operationName = "S_PERSON_ADD_SERVICE_MANUAL_RATE_V001")
    @WebResult(name = "S_PERSON_ADD_SERVICE_MANUAL_RATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPERSONADDSERVICEMANUALRATEV001Response sPERSONADDSERVICEMANUALRATEV001(
        @WebParam(name = "S_PERSON_ADD_SERVICE_MANUAL_RATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPERSONADDSERVICEMANUALRATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service adds a service on a specific person
     * 
     * 			INPUT:
     * 				PERSON-OBJID:		ObjID of the person, which can be obtained from defined services			Mandatory
     * 				servicecode:		service code, combobox key, which can be obtained from defined services			Mandatory
     * 				datefrom:		start date for the service								Mandatory
     * 				dateto:			end date for the service								Mandatory
     * 				ratecategory:		rate category, combobox key								Optional
     * 				pricesegment:		price segement, combobox key								Optional
     * 				quantity:		quantity										Optional
     * 				discountgroup:		discount group, combobox key								Optional
     * 				currency:		currency, combobox key									Optional
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPERSONADDSERVICEV001Response
     */
    @WebMethod(operationName = "S_PERSON_ADD_SERVICE_V001")
    @WebResult(name = "S_PERSON_ADD_SERVICE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPERSONADDSERVICEV001Response sPERSONADDSERVICEV001(
        @WebParam(name = "S_PERSON_ADD_SERVICE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPERSONADDSERVICEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add a specific guest to a specific person.
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services		Mandatory
     * 				GUEST-OBJID:	ObjID of the guest, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPERSONASSSIGNGUESTV001Response
     */
    @WebMethod(operationName = "S_PERSON_ASSSIGN_GUEST_V001")
    @WebResult(name = "S_PERSON_ASSSIGN_GUEST_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPERSONASSSIGNGUESTV001Response sPERSONASSSIGNGUESTV001(
        @WebParam(name = "S_PERSON_ASSSIGN_GUEST_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPERSONASSSIGNGUESTV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service lists all services/packages from a specific person
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Lists all services/packages
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPERSONGETSERVICESV01Response
     */
    @WebMethod(operationName = "S_PERSON_GET_SERVICES_V01")
    @WebResult(name = "S_PERSON_GET_SERVICES_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPERSONGETSERVICESV01Response sPERSONGETSERVICESV01(
        @WebParam(name = "S_PERSON_GET_SERVICES_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPERSONGETSERVICESV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modify a person.
     * 
     * 			INPUT:
     * 				PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 				All data to be changed
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPERSONMODIFYV001Response
     */
    @WebMethod(operationName = "S_PERSON_MODIFY_V001")
    @WebResult(name = "S_PERSON_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPERSONMODIFYV001Response sPERSONMODIFYV001(
        @WebParam(name = "S_PERSON_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPERSONMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service removes a specific service/package from a specific person
     * 
     * 			INPUT:
     * 				PERSON-OBJID:		ObjID of the person, which can be obtained from defined services			Mandatory
     * 				SERVICE-OBJID:		ObjID of the service, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPERSONREMOVESERVICEV001Response
     */
    @WebMethod(operationName = "S_PERSON_REMOVE_SERVICE_V001")
    @WebResult(name = "S_PERSON_REMOVE_SERVICE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPERSONREMOVESERVICEV001Response sPERSONREMOVESERVICEV001(
        @WebParam(name = "S_PERSON_REMOVE_SERVICE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPERSONREMOVESERVICEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service removes a person from a reservation.
     * 
     * 			INPUT:
     * 				- PERSON-OBJID:	ObjID of the person, which can be obtained from defined services			Mandatory
     * 				
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPERSONREMOVEV001Response
     */
    @WebMethod(operationName = "S_PERSON_REMOVE_V001")
    @WebResult(name = "S_PERSON_REMOVE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPERSONREMOVEV001Response sPERSONREMOVEV001(
        @WebParam(name = "S_PERSON_REMOVE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPERSONREMOVEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modifiy a specific policelist entry.
     * 
     * 			INPUT:
     * 				POLICELIST-OBJID:	ObjID of the policelist entry, which can be obtained from defined services			Mandatory
     * 				All data to be modifiy
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPOLICELISTADDV001Response
     */
    @WebMethod(operationName = "S_POLICELIST_ADD_V001")
    @WebResult(name = "S_POLICELIST_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPOLICELISTADDV001Response sPOLICELISTADDV001(
        @WebParam(name = "S_POLICELIST_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPOLICELISTADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modifiy a specific policelist entry.
     * 
     * 			INPUT:
     * 				POLICELIST-OBJID:	ObjID of the policelist entry, which can be obtained from defined services			Mandatory
     * 				All data to be modifiy
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SPOLICELISTMODIFYV001Response
     */
    @WebMethod(operationName = "S_POLICELIST_MODIFY_V001")
    @WebResult(name = "S_POLICELIST_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SPOLICELISTMODIFYV001Response sPOLICELISTMODIFYV001(
        @WebParam(name = "S_POLICELIST_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SPOLICELISTMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service delivers the rate for a specific service for a specific period.
     * 
     * 			INPUT:
     * 				from:			service date from
     * 				to:			service date to
     * 				serviceCode:		service code for the service
     * 				rateCategory:		rate category for the service
     * 				rateSegment:		(Optional) rate segment for the service
     * 				scope:			(Optional) e.g. 
     * 								"FORCECALCDAYPRICE"	- price per day will be returned
     * 				discountGroup:		(Optional) discount group for the service
     * 				currency:		(Optional) currency to which you want to convert
     * 				GUEST-OBJID:		(Optional) guest specific price
     * 				ALLOTMENT-OBJID:	(Optional) allotment specific price
     * 				
     * 				List of person types	(Optional)
     * 					guestType:	(Optional) type of the guest
     * 					noOfPax:	number of persons
     * 					
     * 			OUTPUT:
     * 				- Rate you are looking for and optional a list with the daily rates
     * 				
     * 				- Within each daily rate node, some occupancy data is also included. Please note that:
     * 					- For sales categories, the occupancy percentage is not calculated so 0 will be the returned value
     * 					- The number of occupied rooms is a calculated figure between the total and available rooms. 
     * 					  Consequently, if the request is for a sales category with a defined maximum availability, it can be inaccurate.
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRATESEARCHV001Response
     */
    @WebMethod(operationName = "S_RATE_SEARCH_V001")
    @WebResult(name = "S_RATE_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRATESEARCHV001Response sRATESEARCHV001(
        @WebParam(name = "S_RATE_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRATESEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service can be used to search for rate segment restrictions
     * 
     * 			INPUT (SEARCH CRITERIA):
     * 				rateSegment		(Optional)
     * 				dateFrom		(Optional)
     * 				dateTo                  (Optional)
     * 				toBeSoldFrom		(Optional)
     * 				toBeSoldTo		(Optional)
     * 				
     * 			OUTPUT:
     * 				List of rate segment restrictions matching the search criteria
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRATESEGMENTRESTRICTIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_RATE_SEGMENT_RESTRICTION_SEARCH_V001")
    @WebResult(name = "S_RATE_SEGMENT_RESTRICTION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRATESEGMENTRESTRICTIONSEARCHV001Response sRATESEGMENTRESTRICTIONSEARCHV001(
        @WebParam(name = "S_RATE_SEGMENT_RESTRICTION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRATESEGMENTRESTRICTIONSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns a registration card.
     * 
     * 			INPUT:
     * 				REGISTRATIONCARD-OBJID:	ObjID of the registration card, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				registration card
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SREGISTRATIONCARDGETV001Response
     */
    @WebMethod(operationName = "S_REGISTRATIONCARD_GET_V001")
    @WebResult(name = "S_REGISTRATIONCARD_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SREGISTRATIONCARDGETV001Response sREGISTRATIONCARDGETV001(
        @WebParam(name = "S_REGISTRATIONCARD_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SREGISTRATIONCARDGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modify a registration card.
     * 
     * 			INPUT:
     * 				REGISTRATIONCARD-OBJID:	ObjID of the registration card, which can be obtained from defined services			Mandatory
     * 				All data to be changed
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SREGISTRATIONCARDMODIFYV001Response
     */
    @WebMethod(operationName = "S_REGISTRATIONCARD_MODIFY_V001")
    @WebResult(name = "S_REGISTRATIONCARD_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SREGISTRATIONCARDMODIFYV001Response sREGISTRATIONCARDMODIFYV001(
        @WebParam(name = "S_REGISTRATIONCARD_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SREGISTRATIONCARDMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service removes settlement profiles from a specific guest.
     * 
     * 			INPUT:
     * 				GUEST-OBJID:			ObjID of the guest, which can be obtained from defined services
     * 				or
     * 				GUEST-CENTRALID:		CentralID of the guest, which can be obtained from defined services
     * 				
     * 				SETTLEMENT-PROFILE-OBJID:	ObjID of the settlement profile guest to be removed, which can be obtained from defined services
     * 				or
     * 				SETTLEMENT-PROFILE-CENTRALID:	CentralID of the settlement profile guest to be removed, which can be obtained from defined services
     * 
     * 			OUTPUT:
     * 				Empty: only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SREMOVESETTLEMENTPROFILEV001Response
     */
    @WebMethod(operationName = "S_REMOVE_SETTLEMENT_PROFILE_V001")
    @WebResult(name = "S_REMOVE_SETTLEMENT_PROFILE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SREMOVESETTLEMENTPROFILEV001Response sREMOVESETTLEMENTPROFILEV001(
        @WebParam(name = "S_REMOVE_SETTLEMENT_PROFILE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SREMOVESETTLEMENTPROFILEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add rooms/persons to the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 				category:		room category
     * 				noOfPax:		number of persons
     * 				noOfRooms:		number of rooms
     * 				rateCategory:		rate category
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONADDROOMV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_ADD_ROOM_V001")
    @WebResult(name = "S_RESERVATION_ADD_ROOM_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONADDROOMV001Response sRESERVATIONADDROOMV001(
        @WebParam(name = "S_RESERVATION_ADD_ROOM_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONADDROOMV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service adds a service with manual rate on a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 				servicecode:		service code, combobox key, which can be obtained from defined services			Mandatory
     * 				datefrom:		start date for the service								Mandatory
     * 				dateto:			end date for the service								Mandatory
     * 				ratecategory:		rate category, combobox key								Optional
     * 				pricesegment:		price segement, combobox key								Optional
     * 				quantity:		quantity										Optional
     * 				manualrate:		price per unit per day									Optional
     * 				discountgroup:		discount group, combobox key								Optional
     * 				currency:		currency, combobox key									Optional
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONADDSERVICEMANUALRATEV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001")
    @WebResult(name = "S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONADDSERVICEMANUALRATEV001Response sRESERVATIONADDSERVICEMANUALRATEV001(
        @WebParam(name = "S_RESERVATION_ADD_SERVICE_MANUAL_RATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONADDSERVICEMANUALRATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service adds a service on a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 				servicecode:		service code, combobox key, which can be obtained from defined services			Mandatory
     * 				datefrom:		start date for the service								Mandatory
     * 				dateto:			end date for the service								Mandatory
     * 				ratecategory:		rate category, combobox key								Optional
     * 				pricesegment:		price segement, combobox key								Optional
     * 				quantity:		quantity										Optional
     * 				discountgroup:		discount group, combobox key								Optional
     * 				currency:		currency, combobox key									Optional
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONADDSERVICEV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_ADD_SERVICE_V001")
    @WebResult(name = "S_RESERVATION_ADD_SERVICE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONADDSERVICEV001Response sRESERVATIONADDSERVICEV001(
        @WebParam(name = "S_RESERVATION_ADD_SERVICE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONADDSERVICEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service assigned a automatic searched rooms to the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONAUTOASSIGNROOMV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_AUTO_ASSIGN_ROOM_V001")
    @WebResult(name = "S_RESERVATION_AUTO_ASSIGN_ROOM_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONAUTOASSIGNROOMV001Response sRESERVATIONAUTOASSIGNROOMV001(
        @WebParam(name = "S_RESERVATION_AUTO_ASSIGN_ROOM_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONAUTOASSIGNROOMV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service checked in the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONCHECKINV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_CHECK_IN_V001")
    @WebResult(name = "S_RESERVATION_CHECK_IN_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONCHECKINV001Response sRESERVATIONCHECKINV001(
        @WebParam(name = "S_RESERVATION_CHECK_IN_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONCHECKINV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service creates a new individual reservation
     * 			INPUT:
     * 				ORDERER-OBJID:		(Mandatory) ObjID of the orderer, which can be obtained from other defined services		Mandatory
     * 				Reservation data
     * 				
     * 				Other optional fields:
     * 				
     * 					ORDERER-OBJID:				ObjID of the orderer
     * 					TRAVELAGENCY-OBJID			ObjID of the travel agency
     * 					TRAVELPOINT-OBJID			ObjID of the travel point
     * 					ORDERERCONTACTPERSON-OBJID		ObjID of the orderer contact person (make sure it's a valid contact person for ORDERER-OBJID)
     * 					TRAVELAGENCYCONTACTPERSON-OBJID		ObjID of the travel agency contact person (make sure it's a valid contact person for TRAVELAGENCY-OBJID)
     * 					TRAVELPOINTCONTACTPERSON-OBJID		ObjID of the travel point contact person (make sure it's a valid contact person for TRAVELPOINT-OBJID)
     * 					ALLOTMENT-OBJID				ObjID of the allotment
     * 					
     * 				
     * 				When creating a reservation linked to an allotment (with the exception of shared allotments):
     * 				
     * 					In general: the allotment needs to belong to the orderer of the reservation (holder)
     * 					However, this depends on who the rate is assigned to, which can also be defined
     * 				
     * 			OUTPUT:
     * 				RESERVATION-OBJID:		ObjID of the newly created reservation
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONCREATEV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_CREATE_V001")
    @WebResult(name = "S_RESERVATION_CREATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONCREATEV001Response sRESERVATIONCREATEV001(
        @WebParam(name = "S_RESERVATION_CREATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONCREATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service lists all services/packages from a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Lists all services/packages
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGETSERVICESV01Response
     */
    @WebMethod(operationName = "S_RESERVATION_GET_SERVICES_V01")
    @WebResult(name = "S_RESERVATION_GET_SERVICES_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGETSERVICESV01Response sRESERVATIONGETSERVICESV01(
        @WebParam(name = "S_RESERVATION_GET_SERVICES_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGETSERVICESV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service returns a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:		ObjID of the reservation, which can be obtained from other defined services		Mandatory
     * 
     * 			OUTPUT:
     * 				Reservation data
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGETV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GET_V001")
    @WebResult(name = "S_RESERVATION_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGETV001Response sRESERVATIONGETV001(
        @WebParam(name = "S_RESERVATION_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service creates a new reservation which is the first element of a group.
     * 				To add new "elements" to an existing group, the following service should be used: S_RESERVATION_GROUP_RESERVATION_ADD...
     * 
     * 			INPUT:
     * 				ORDERER-OBJID:		ObjID of the orderer, which can be obtained from other defined services		Mandatory
     * 				Reservation data
     * 				
     * 				Other optional fields:
     * 				
     * 					ORDERER-OBJID:			ObjID of the orderer
     * 					TRAVELAGENCY-OBJID			ObjID of the travel agency
     * 					TRAVELPOINT-OBJID			ObjID of the travel point
     * 					ORDERERCONTACTPERSON-OBJID		ObjID of the orderer contact person (make sure it's a valid contact person for ORDERER-OBJID)
     * 					TRAVELAGENCYCONTACTPERSON-OBJID	ObjID of the travel agency contact person (make sure it's a valid contact person for TRAVELAGENCY-OBJID)
     * 					TRAVELPOINTCONTACTPERSON-OBJID	ObjID of the travel point contact person (make sure it's a valid contact person for TRAVELPOINT-OBJID)
     * 					ALLOTMENT-OBJID			ObjID of the allotment
     * 					
     * 				
     * 				When creating a reservation linked to an allotment (with the exception of shared allotments):
     * 				
     * 					In general: the allotment needs to belong to the orderer of the reservation (holder)
     * 					However, this depends on who the rate is assigned to, which can also be defined
     * 				
     * 			OUTPUT:
     * 				RESERVATION-OBJID:		ObjID of the newly created reservation
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPCREATEV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_CREATE_V001")
    @WebResult(name = "S_RESERVATION_GROUP_CREATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPCREATEV001Response sRESERVATIONGROUPCREATEV001(
        @WebParam(name = "S_RESERVATION_GROUP_CREATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPCREATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service activates group handling on fo-reservations
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services		
     * 				
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPHANDLINGACTIVATEV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001")
    @WebResult(name = "S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPHANDLINGACTIVATEV001Response sRESERVATIONGROUPHANDLINGACTIVATEV001(
        @WebParam(name = "S_RESERVATION_GROUP_HANDLING_ACTIVATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPHANDLINGACTIVATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add group reservation to the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			
     * 
     * 			OUTPUT:
     * 				reservation  data
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPRESERVATIONADDV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_RESERVATION_ADD_V001")
    @WebResult(name = "S_RESERVATION_GROUP_RESERVATION_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPRESERVATIONADDV001Response sRESERVATIONGROUPRESERVATIONADDV001(
        @WebParam(name = "S_RESERVATION_GROUP_RESERVATION_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPRESERVATIONADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add group reservation to the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			
     * 
     * 			OUTPUT:
     * 				reservation  data
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPRESERVATIONADDV002Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_RESERVATION_ADD_V002")
    @WebResult(name = "S_RESERVATION_GROUP_RESERVATION_ADD_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPRESERVATIONADDV002Response sRESERVATIONGROUPRESERVATIONADDV002(
        @WebParam(name = "S_RESERVATION_GROUP_RESERVATION_ADD_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPRESERVATIONADDV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service adds a group reservation to a reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			
     * 
     * 			OUTPUT:
     * 				RESERVATION-OBJID:	ObjID of the newly created reservation
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPRESERVATIONADDV003Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_RESERVATION_ADD_V003")
    @WebResult(name = "S_RESERVATION_GROUP_RESERVATION_ADD_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPRESERVATIONADDV003Response sRESERVATIONGROUPRESERVATIONADDV003(
        @WebParam(name = "S_RESERVATION_GROUP_RESERVATION_ADD_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPRESERVATIONADDV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service get all group reservation from the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which set a group reservation		
     * 
     * 			OUTPUT:
     * 				reservation  data
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPRESERVATIONGETV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_RESERVATION_GET_V001")
    @WebResult(name = "S_RESERVATION_GROUP_RESERVATION_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPRESERVATIONGETV001Response sRESERVATIONGROUPRESERVATIONGETV001(
        @WebParam(name = "S_RESERVATION_GROUP_RESERVATION_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPRESERVATIONGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add rooms/persons to the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPRESERVATIONSETCANCELV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001")
    @WebResult(name = "S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPRESERVATIONSETCANCELV001Response sRESERVATIONGROUPRESERVATIONSETCANCELV001(
        @WebParam(name = "S_RESERVATION_GROUP_RESERVATION_SET_CANCEL_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPRESERVATIONSETCANCELV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add rooms/persons to the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 			SOAP EXAMPLE REQUEST:
     * 				
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPRESERVATIONSETNOSHOWV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001")
    @WebResult(name = "S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPRESERVATIONSETNOSHOWV001Response sRESERVATIONGROUPRESERVATIONSETNOSHOWV001(
        @WebParam(name = "S_RESERVATION_GROUP_RESERVATION_SET_NOSHOW_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPRESERVATIONSETNOSHOWV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service add rooms/persons to the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONGROUPRESERVATIONSETRELEASEV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001")
    @WebResult(name = "S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONGROUPRESERVATIONSETRELEASEV001Response sRESERVATIONGROUPRESERVATIONSETRELEASEV001(
        @WebParam(name = "S_RESERVATION_GROUP_RESERVATION_SET_RELEASE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONGROUPRESERVATIONSETRELEASEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service modifies an existing reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:		ObjID of the reservation to be modified, which can be obtained from other defined services		Mandatory
     * 				All reservation data to be changed
     * 				
     * 			OUTPUT:
     * 				Empty: only result tag
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONMODIFYV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_MODIFY_V001")
    @WebResult(name = "S_RESERVATION_MODIFY_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONMODIFYV001Response sRESERVATIONMODIFYV001(
        @WebParam(name = "S_RESERVATION_MODIFY_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONMODIFYV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service released the rooms from the reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the RESERVATION, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONRELEASEROOMV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_RELEASE_ROOM_V001")
    @WebResult(name = "S_RESERVATION_RELEASE_ROOM_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONRELEASEROOMV001Response sRESERVATIONRELEASEROOMV001(
        @WebParam(name = "S_RESERVATION_RELEASE_ROOM_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONRELEASEROOMV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service removes a specific service/package from a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 				SERVICE-OBJID:		ObjID of the service, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONREMOVESERVICEV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_REMOVE_SERVICE_V001")
    @WebResult(name = "S_RESERVATION_REMOVE_SERVICE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONREMOVESERVICEV001Response sRESERVATIONREMOVESERVICEV001(
        @WebParam(name = "S_RESERVATION_REMOVE_SERVICE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONREMOVESERVICEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for reservations
     * 
     * 			INPUT:
     * 				resnofrom:		start reservation number			Optional
     * 				resnoto:		end reservation number				Optional
     * 				gdsresnumber:		GDS number of the reservation			Optional
     * 				arrival:		arrival date of the reservation			Optional
     * 				departure:		departure date of the reservation		Optional
     * 
     * 			OUTPUT:
     * 				List of reservation matching the request
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_SEARCH_V001")
    @WebResult(name = "S_RESERVATION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONSEARCHV001Response sRESERVATIONSEARCHV001(
        @WebParam(name = "S_RESERVATION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for reservations
     * 
     * 			INPUT:
     * 				resnofrom:		start reservation number			Optional
     * 				resnoto:		end reservation number				Optional
     * 				gdsresnumber:		GDS number of the reservation			Optional
     * 				arrival:		arrival date of the reservation			Optional
     * 				departure:		departure date of the reservation		Optional
     * 				hotel:			hotel number of the reservation			Optional
     * 
     * 			OUTPUT:
     * 				List of reservation matching the request
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONSEARCHV002Response
     */
    @WebMethod(operationName = "S_RESERVATION_SEARCH_V002")
    @WebResult(name = "S_RESERVATION_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONSEARCHV002Response sRESERVATIONSEARCHV002(
        @WebParam(name = "S_RESERVATION_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONSEARCHV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for reservations
     * 
     * 			INPUT:
     * 				resnofrom:		start reservation number		Optional
     * 				resnoto:		end reservation number			Optional
     * 				gdsresnumber:		GDS number of the reservation		Optional
     * 				arrival:		arrival date of the reservation		Optional
     * 				departure:		departure date of the reservation	Optional
     * 				hotel:			hotel number of the reservation		Optional
     * 				definitiveTentative:	definitive/tentative reservation	Optional				
     * 					Possible values are:
     * 					0 = all, 
     * 					1 = definitive (default),
     * 					2 = tentative, 
     * 					3 = definitive and tentative
     * 							
     * 
     * 			OUTPUT:
     * 				List of reservation matching the request
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONSEARCHV003Response
     */
    @WebMethod(operationName = "S_RESERVATION_SEARCH_V003")
    @WebResult(name = "S_RESERVATION_SEARCH_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONSEARCHV003Response sRESERVATIONSEARCHV003(
        @WebParam(name = "S_RESERVATION_SEARCH_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONSEARCHV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service sets one or more payments instructions for a specific reservation
     * 
     * 			INPUT:
     * 				<reservation>RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services (mandatory)
     * 				<guestPaymentInstruction>GUEST-OBJID:	ObjID of the guest profile, which should be added for the guest account payment instructions.
     * 				<clientPaymentInstruction>GUEST-OBJID:	ObjID of the guest profile, which should be added for the client account payment instructions.
     * 				<groupPaymentInstruction>GUEST-OBJID:	ObjID of the guest profile, which should be added for the group account payment instructions.
     * 
     * 			OUTPUT:
     * 				actuall values from the reservation to check if the set was successful
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONSETPAYMENTINSTRCUTIONV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_SET_PAYMENTINSTRCUTION_V001")
    @WebResult(name = "S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONSETPAYMENTINSTRCUTIONV001Response sRESERVATIONSETPAYMENTINSTRCUTIONV001(
        @WebParam(name = "S_RESERVATION_SET_PAYMENTINSTRCUTION_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONSETPAYMENTINSTRCUTIONV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service return a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				reservation  data
     * 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONV001Response
     */
    @WebMethod(operationName = "S_RESERVATION_V001")
    @WebResult(name = "S_RESERVATION_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONV001Response sRESERVATIONV001(
        @WebParam(name = "S_RESERVATION_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service return a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				reservation data
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONV002Response
     */
    @WebMethod(operationName = "S_RESERVATION_V002")
    @WebResult(name = "S_RESERVATION_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONV002Response sRESERVATIONV002(
        @WebParam(name = "S_RESERVATION_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service return a specific reservation
     * 
     * 			INPUT:
     * 				RESERVATION-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				reservation data
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SRESERVATIONV003Response
     */
    @WebMethod(operationName = "S_RESERVATION_V003")
    @WebResult(name = "S_RESERVATION_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SRESERVATIONV003Response sRESERVATIONV003(
        @WebParam(name = "S_RESERVATION_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SRESERVATIONV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service assigned a specific room to the rooming list
     * 
     * 			INPUT:
     * 				ROOMINGLIST-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 				room:			room number of a free room, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMINGLISTASSIGNROOMV001Response
     */
    @WebMethod(operationName = "S_ROOMINGLIST_ASSIGN_ROOM_V001")
    @WebResult(name = "S_ROOMINGLIST_ASSIGN_ROOM_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMINGLISTASSIGNROOMV001Response sROOMINGLISTASSIGNROOMV001(
        @WebParam(name = "S_ROOMINGLIST_ASSIGN_ROOM_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMINGLISTASSIGNROOMV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service assigned a automatic searched room to the rooming list
     * 
     * 			INPUT:
     * 				ROOMINGLIST-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMINGLISTAUTOASSIGNROOMV001Response
     */
    @WebMethod(operationName = "S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001")
    @WebResult(name = "S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMINGLISTAUTOASSIGNROOMV001Response sROOMINGLISTAUTOASSIGNROOMV001(
        @WebParam(name = "S_ROOMINGLIST_AUTO_ASSIGN_ROOM_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMINGLISTAUTOASSIGNROOMV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service checked in the rooming list
     * 
     * 			INPUT:
     * 				ROOMINGLIST-OBJID:	ObjID of the reservation, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMINGLISTCHECKINV001Response
     */
    @WebMethod(operationName = "S_ROOMINGLIST_CHECK_IN_V001")
    @WebResult(name = "S_ROOMINGLIST_CHECK_IN_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMINGLISTCHECKINV001Response sROOMINGLISTCHECKINV001(
        @WebParam(name = "S_ROOMINGLIST_CHECK_IN_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMINGLISTCHECKINV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service released a specific room from the roominglist
     * 
     * 			INPUT:
     * 				ROOMINGLIST-OBJID:	ObjID of the rooming list, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				Empty: 			only Result-Tag will be returned 
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMINGLISTRELEASEROOMV001Response
     */
    @WebMethod(operationName = "S_ROOMINGLIST_RELEASE_ROOM_V001")
    @WebResult(name = "S_ROOMINGLIST_RELEASE_ROOM_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMINGLISTRELEASEROOMV001Response sROOMINGLISTRELEASEROOMV001(
        @WebParam(name = "S_ROOMINGLIST_RELEASE_ROOM_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMINGLISTRELEASEROOMV001Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMBOOKINGOOILOCKV001Response
     */
    @WebMethod(operationName = "S_ROOM_BOOKING_OOI_LOCK_V001")
    @WebResult(name = "S_ROOM_BOOKING_OOI_LOCK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMBOOKINGOOILOCKV001Response sROOMBOOKINGOOILOCKV001(
        @WebParam(name = "S_ROOM_BOOKING_OOI_LOCK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMBOOKINGOOILOCKV001Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMBOOKINGOOIUNLOCKV001Response
     */
    @WebMethod(operationName = "S_ROOM_BOOKING_OOI_UNLOCK_V001")
    @WebResult(name = "S_ROOM_BOOKING_OOI_UNLOCK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMBOOKINGOOIUNLOCKV001Response sROOMBOOKINGOOIUNLOCKV001(
        @WebParam(name = "S_ROOM_BOOKING_OOI_UNLOCK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMBOOKINGOOIUNLOCKV001Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMBOOKINGOOOLOCKV001Response
     */
    @WebMethod(operationName = "S_ROOM_BOOKING_OOO_LOCK_V001")
    @WebResult(name = "S_ROOM_BOOKING_OOO_LOCK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMBOOKINGOOOLOCKV001Response sROOMBOOKINGOOOLOCKV001(
        @WebParam(name = "S_ROOM_BOOKING_OOO_LOCK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMBOOKINGOOOLOCKV001Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMBOOKINGOOOUNLOCKV001Response
     */
    @WebMethod(operationName = "S_ROOM_BOOKING_OOO_UNLOCK_V001")
    @WebResult(name = "S_ROOM_BOOKING_OOO_UNLOCK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMBOOKINGOOOUNLOCKV001Response sROOMBOOKINGOOOUNLOCKV001(
        @WebParam(name = "S_ROOM_BOOKING_OOO_UNLOCK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMBOOKINGOOOUNLOCKV001Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMBOOKINGOOSLOCKV001Response
     */
    @WebMethod(operationName = "S_ROOM_BOOKING_OOS_LOCK_V001")
    @WebResult(name = "S_ROOM_BOOKING_OOS_LOCK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMBOOKINGOOSLOCKV001Response sROOMBOOKINGOOSLOCKV001(
        @WebParam(name = "S_ROOM_BOOKING_OOS_LOCK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMBOOKINGOOSLOCKV001Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMBOOKINGOOSUNLOCKV001Response
     */
    @WebMethod(operationName = "S_ROOM_BOOKING_OOS_UNLOCK_V001")
    @WebResult(name = "S_ROOM_BOOKING_OOS_UNLOCK_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMBOOKINGOOSUNLOCKV001Response sROOMBOOKINGOOSUNLOCKV001(
        @WebParam(name = "S_ROOM_BOOKING_OOS_UNLOCK_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMBOOKINGOOSUNLOCKV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for room states; the result set contains either a list of rooms or a specific room
     * 
     * 			INPUT: 
     * 				ROOM-OBJID:	ObjID of the room, which can be obtained from defined services			Mandatory
     * 
     * 			OUTPUT:
     * 				room booking state
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMBOOKINGSTATEV01Response
     */
    @WebMethod(operationName = "S_ROOM_BOOKING_STATE_V01")
    @WebResult(name = "S_ROOM_BOOKING_STATE_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMBOOKINGSTATEV01Response sROOMBOOKINGSTATEV01(
        @WebParam(name = "S_ROOM_BOOKING_STATE_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMBOOKINGSTATEV01Request body);

    /**
     * 
     * 			
     * 			GENERAL:
     * 				This service gives the translations of the description and comment from room categories.
     * 			   
     * 			INPUT (searchcriteria): 
     * 				category
     * 			
     * 			OUTPUT:
     * 				List of description and comments with language code
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response
     */
    @WebMethod(operationName = "S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001")
    @WebResult(name = "S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response sROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001(
        @WebParam(name = "S_ROOM_CATEGORY_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMCATEGORYMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service changes the room status (cleaning status) of a given room
     * 
     * 			INPUT: 
     * 				ROOM-OBJID: 		Mandatory. Object ID of the room, which can be obtained from defined services
     * 				Cleaning_Status:	Mandatory. One of the configured cleaning status for the hotel needs to be entered.
     * 							Standard cleaning status are: 01 - Dirty; 02 - In Process; 03 - Inspection; 04 - Room OK; 05 - Additional Work; 06 - Arrival Not Clean
     * 
     * 			OUTPUT:
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMCHANGECLEANINGSTATUSV01Response
     */
    @WebMethod(operationName = "S_ROOM_CHANGE_CLEANING_STATUS_V01")
    @WebResult(name = "S_ROOM_CHANGE_CLEANING_STATUS_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMCHANGECLEANINGSTATUSV01Response sROOMCHANGECLEANINGSTATUSV01(
        @WebParam(name = "S_ROOM_CHANGE_CLEANING_STATUS_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMCHANGECLEANINGSTATUSV01Request body);

    /**
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMCHANGECLEANUNGSTATUSV01Response
     */
    @WebMethod(operationName = "S_ROOM_CHANGE_CLEANUNG_STATUS_V01")
    @WebResult(name = "S_ROOM_CHANGE_CLEANUNG_STATUS_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMCHANGECLEANUNGSTATUSV01Response sROOMCHANGECLEANUNGSTATUSV01(
        @WebParam(name = "S_ROOM_CHANGE_CLEANUNG_STATUS_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMCHANGECLEANUNGSTATUSV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service changes the room status (maintenance status) of a given room
     * 
     * 			INPUT:
     * 				ROOM-OBJID: 	Mandatory. Object ID of the room, which can be obtained from defined services
     * 				maintenance: 	Mandatory. One of the configured maintenance status for the hotel needs to be entered.
     * 						Standard maintenance status are (combobox '27' ): 99 - Maintenance OK; 98 - General Maintenance; ...
     * 
     * 			OUTPUT:
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMCHANGEMAINTENANCESTATUSV01Response
     */
    @WebMethod(operationName = "S_ROOM_CHANGE_MAINTENANCE_STATUS_V01")
    @WebResult(name = "S_ROOM_CHANGE_MAINTENANCE_STATUS_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMCHANGEMAINTENANCESTATUSV01Response sROOMCHANGEMAINTENANCESTATUSV01(
        @WebParam(name = "S_ROOM_CHANGE_MAINTENANCE_STATUS_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMCHANGEMAINTENANCESTATUSV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service changes the room status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMCHANGESTATEV01Response
     */
    @WebMethod(operationName = "S_ROOM_CHANGE_STATE_V01")
    @WebResult(name = "S_ROOM_CHANGE_STATE_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMCHANGESTATEV01Response sROOMCHANGESTATEV01(
        @WebParam(name = "S_ROOM_CHANGE_STATE_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMCHANGESTATEV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the active maintenance requests of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETACTIVEMAINTENANCESTATEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001")
    @WebResult(name = "S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETACTIVEMAINTENANCESTATEV001Response sROOMGETACTIVEMAINTENANCESTATEV001(
        @WebParam(name = "S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETACTIVEMAINTENANCESTATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the active maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001")
    @WebResult(name = "S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV001Response sROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV001(
        @WebParam(name = "S_ROOM_GET_ACTIVE_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETACTIVEMAINTENANCESTATEWITHOUTIMAGEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the housekeeping status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETHOUSKEEPINGSTATEMOBILEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001")
    @WebResult(name = "S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETHOUSKEEPINGSTATEMOBILEV001Response sROOMGETHOUSKEEPINGSTATEMOBILEV001(
        @WebParam(name = "S_ROOM_GET_HOUSKEEPING_STATE_MOBILE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETHOUSKEEPINGSTATEMOBILEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the housekeeping status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETHOUSKEEPINGSTATEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_HOUSKEEPING_STATE_V001")
    @WebResult(name = "S_ROOM_GET_HOUSKEEPING_STATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETHOUSKEEPINGSTATEV001Response sROOMGETHOUSKEEPINGSTATEV001(
        @WebParam(name = "S_ROOM_GET_HOUSKEEPING_STATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETHOUSKEEPINGSTATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINENANCESTATEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINENANCE_STATE_V001")
    @WebResult(name = "S_ROOM_GET_MAINENANCE_STATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINENANCESTATEV001Response sROOMGETMAINENANCESTATEV001(
        @WebParam(name = "S_ROOM_GET_MAINENANCE_STATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINENANCESTATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINTENANCESTATEMOBILEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001")
    @WebResult(name = "S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINTENANCESTATEMOBILEV001Response sROOMGETMAINTENANCESTATEMOBILEV001(
        @WebParam(name = "S_ROOM_GET_MAINTENANCE_STATE_MOBILE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINTENANCESTATEMOBILEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list all maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINTENANCESTATEV002Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINTENANCE_STATE_V002")
    @WebResult(name = "S_ROOM_GET_MAINTENANCE_STATE_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINTENANCESTATEV002Response sROOMGETMAINTENANCESTATEV002(
        @WebParam(name = "S_ROOM_GET_MAINTENANCE_STATE_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINTENANCESTATEV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001")
    @WebResult(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV001Response sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV001(
        @WebParam(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV002Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002")
    @WebResult(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV002Response sROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV002(
        @WebParam(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_MOBILE_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINTENANCESTATEWITHOUTIMAGEMOBILEV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINTENANCESTATEWITHOUTIMAGEV001Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001")
    @WebResult(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINTENANCESTATEWITHOUTIMAGEV001Response sROOMGETMAINTENANCESTATEWITHOUTIMAGEV001(
        @WebParam(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINTENANCESTATEWITHOUTIMAGEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINTENANCESTATEWITHOUTIMAGEV002Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002")
    @WebResult(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINTENANCESTATEWITHOUTIMAGEV002Response sROOMGETMAINTENANCESTATEWITHOUTIMAGEV002(
        @WebParam(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINTENANCESTATEWITHOUTIMAGEV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service list the maintenance status of a specific room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMGETMAINTENANCESTATEWITHOUTIMAGEV003Response
     */
    @WebMethod(operationName = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003")
    @WebResult(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMGETMAINTENANCESTATEWITHOUTIMAGEV003Response sROOMGETMAINTENANCESTATEWITHOUTIMAGEV003(
        @WebParam(name = "S_ROOM_GET_MAINTENANCE_STATE_WITHOUT_IMAGE_V003Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMGETMAINTENANCESTATEWITHOUTIMAGEV003Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service Lists rooms with their locked status
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMLOCKSTATESEARCHV001Response
     */
    @WebMethod(operationName = "S_ROOM_LOCK_STATE_SEARCH_V001")
    @WebResult(name = "S_ROOM_LOCK_STATE_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMLOCKSTATESEARCHV001Response sROOMLOCKSTATESEARCHV001(
        @WebParam(name = "S_ROOM_LOCK_STATE_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMLOCKSTATESEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service resets a specific maintenance status of a room
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMRESETMAINTENANCESTATEV001Response
     */
    @WebMethod(operationName = "S_ROOM_RESET_MAINTENANCE_STATE_V001")
    @WebResult(name = "S_ROOM_RESET_MAINTENANCE_STATE_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMRESETMAINTENANCESTATEV001Response sROOMRESETMAINTENANCESTATEV001(
        @WebParam(name = "S_ROOM_RESET_MAINTENANCE_STATE_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMRESETMAINTENANCESTATEV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for room states; the result set contains either a list of rooms or a specific room
     * 				In case of no input criteria is given, a list of all configured rooms will be returned
     * 
     * 			INPUT (searchcriteria, all optional): 
     * 				room as room number:	 empty field results a list of rooms related to the other search criteria or all rooms (see above)
     * 				category:		room category; e.g. BD = Business Double
     * 				floor:			floor the room is located
     * 				changesupplies:		as housekeeping state defined in PMS; e.g. 04 - Room OK; 06 - Arrival Not Clean
     * 				maintenance:		as technical state of the room, e.g. 57 - heater faulty, 
     * 			
     * 				All the parameters above beside room number are configurable and need to be requested from hotel in forehand
     * 
     * 			OUTPUT:
     * 				room_number:		number of the room
     * 				floor:			location of the room, number of the floor as configured in SIHOT
     * 				status:			status of room, e.g. not occupied, checked in with guest name, blocked
     * 				room_category:		category of the room, e.g. BS (business single)
     * 				housekeeping_state:	sanitation state of the room, e.g. 06 = arrival not clean
     * 				technical_state:	technical state of the room, e.g. 99 = all ok
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMSTATESEARCHV002Response
     */
    @WebMethod(operationName = "S_ROOM_STATE_SEARCH_V002")
    @WebResult(name = "S_ROOM_STATE_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMSTATESEARCHV002Response sROOMSTATESEARCHV002(
        @WebParam(name = "S_ROOM_STATE_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMSTATESEARCHV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for room states; the result set contains either a list of rooms or a specific room
     * 				In case of no input criteria is given, a list of all configured rooms will be returned
     * 
     * 			INPUT (searchcriteria, all optional): 
     * 				room as room number:	 empty field results a list of rooms related to the other search criteria or all rooms (see above)
     * 				category:		room category; e.g. BD = Business Double
     * 				floor:			floor the room is located
     * 				changesupplies:		as housekeeping state defined in PMS; e.g. 04 - Room OK; 06 - Arrival Not Clean
     * 				maintenance:		as technical state of the room, e.g. 57 - heater faulty, 
     * 			
     * 				All the parameters above beside room number are configurable and need to be requested from hotel in forehand
     * 
     * 			OUTPUT:
     * 				room_number:		number of the room
     * 				floor:			location of the room, number of the floor as configured in SIHOT
     * 				status:			status of room, e.g. not occupied, checked in with guest name, blocked
     * 				room_category:		category of the room, e.g. BS (business single)
     * 				housekeeping_state:	sanitation state of the room, e.g. 06 = arrival not clean
     * 				technical_state:	technical state of the room, e.g. 99 = all ok
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SROOMSTATESEARCHV01Response
     */
    @WebMethod(operationName = "S_ROOM_STATE_SEARCH_V01")
    @WebResult(name = "S_ROOM_STATE_SEARCH_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SROOMSTATESEARCHV01Response sROOMSTATESEARCHV01(
        @WebParam(name = "S_ROOM_STATE_SEARCH_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SROOMSTATESEARCHV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service gives the translations of the description and comment from services.
     * 			   
     * 			INPUT (searchcriteria): 
     * 				serviceCode
     * 			
     * 			OUTPUT:
     * 				List of description and comments with language code
     * 				rateSegment is a combobox "PS"
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response
     */
    @WebMethod(operationName = "S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001")
    @WebResult(name = "S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Response sSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001(
        @WebParam(name = "S_SERVICES_MASTER_FILE_MULTILANGUAGE_DESCRIPTION_COMMENT_GET_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SSERVICESMASTERFILEMULTILANGUAGEDESCRIPTIONCOMMENTGETV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for services
     * 
     * 			INPUT:
     * 				servicecode:	service code, combobox key			Optional
     * 				servicetype:	service type, combobox key			Optional
     * 				ratefilter:	rate filter, combobox key			Optional
     * 				ratesegment:	ratesegment, combobox key			Optional
     * 				dateforprice:	date for calculate rate				Optional
     * 
     * 			OUTPUT:
     * 				List of services matching the request
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SSERVICESSEARCHV001Response
     */
    @WebMethod(operationName = "S_SERVICES_SEARCH_V001")
    @WebResult(name = "S_SERVICES_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SSERVICESSEARCHV001Response sSERVICESSEARCHV001(
        @WebParam(name = "S_SERVICES_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SSERVICESSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for services
     * 
     * 			INPUT:
     * 				servicecode:	service code, combobox key			Optional
     * 				servicetype:	service type, combobox key			Optional
     * 				ratefilter:	rate filter, combobox key			Optional
     * 				ratesegment:	ratesegment, combobox key			Optional
     * 				dateforprice:	date for calculate rate				Optional
     * 
     * 			OUTPUT:
     * 				List of services matching the request
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SSERVICESSEARCHV002Response
     */
    @WebMethod(operationName = "S_SERVICES_SEARCH_V002")
    @WebResult(name = "S_SERVICES_SEARCH_V002Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SSERVICESSEARCHV002Response sSERVICESSEARCHV002(
        @WebParam(name = "S_SERVICES_SEARCH_V002Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SSERVICESSEARCHV002Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service can be used to search for service/package restrictions
     * 
     * 			INPUT (SEARCH CRITERIA):
     * 				servicePackage:		(Optional)	Service/package code
     * 				dateFrom		(Optional)
     * 				dateTo			(Optional)
     * 				toBeSoldFrom		(Optional)
     * 				toBeSoldTo		(Optional)
     * 				
     * 			OUTPUT:
     * 				List of service/package restrictions matching the search criteria
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SSERVICEPACKAGERESTRICTIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001")
    @WebResult(name = "S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SSERVICEPACKAGERESTRICTIONSEARCHV001Response sSERVICEPACKAGERESTRICTIONSEARCHV001(
        @WebParam(name = "S_SERVICE_PACKAGE_RESTRICTION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SSERVICEPACKAGERESTRICTIONSEARCHV001Request body);

    /**
     *  
     * 			GENERAL:
     * 				This service is used to create sys messages
     * 			
     * 			INPUT:
     * 				In addition to the SecurityID, the required ACL right must also be specified using type, key and subkey:
     * 				layout rights:		type:	0
     * 							key:	layout-id (example: ID_SIHOT_PACKAGE_MASTER)
     * 							subkey:	<empty>
     * 							right:	view right
     * 				function rights:	type:	1
     * 							key:	business object class (exampe: BO_PackageMasterFile)
     * 							subkey: function (example: update)
     * 							right:	execute right
     * 				relation rights:	type:	2
     * 							key:	business object class (exampe: BO_PackageMasterFile)
     * 							subkey: relation (example: getPartLists)
     * 							right:	execute right
     * 				batch rights:		type:	5
     * 							key:	batch name (exampe: anreiseliste)
     * 							subkey: <empty></empty>
     * 							right:	view right
     * 				service rights:		type:	6
     * 							key:	service id (exampe: GuestSearch)
     * 							subkey: <empty></empty>
     * 							right:	execute right							
     * 				feature rights:		type:	7
     * 							key:	feature number (exampe: 5 /* disable overbooking flag in a reservation *<!---->/)
     * 							subkey: <empty></empty>
     * 							right:	execute right										
     * 				
     * 			OUTPUT:
     * 				The service will return informationen about the required ACL right (execution right or view right; see above)
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SSYSMESSAGEADDV001Response
     */
    @WebMethod(operationName = "S_SYSMESSAGE_ADD_V001")
    @WebResult(name = "S_SYSMESSAGE_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SSYSMESSAGEADDV001Response sSYSMESSAGEADDV001(
        @WebParam(name = "S_SYSMESSAGE_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SSYSMESSAGEADDV001Request body);

    /**
     * 
     * 		GENERAL:
     * 			This service changes the flags of a credit card that is referenced by their object id.
     * 			The object id is part of the notification message that is returned by the tokenisation interface.
     * 			Except of the field "Flags" all fields in CardModifyData are only set if the status of the notification message was successful.
     * 
     * 		INPUT: 
     * 			CARD-OBJID:		Mandatory. Object ID of the credit card.
     * 			Flags:			Mandatory. Flags to set for the credit card.
     * 			Token:			The authorization code from the notification message.
     * 			ExtAddRef:		The Ext. additional reference from the notification message.
     * 			CCType:			The type of the credit card (for example MasterCard or VISA).
     * 			ExpireDateHandle:	The date when the card expires.
     * 			ExpireDate:		The date until the authorisation token is valid.
     * 
     * 		OUTPUT:
     * 		
     * 	
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.STOKENISATIONNOTIFICATIONV01Response
     */
    @WebMethod(operationName = "S_TOKENISATION_NOTIFICATION_V01")
    @WebResult(name = "S_TOKENISATION_NOTIFICATION_V01Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public STOKENISATIONNOTIFICATIONV01Response sTOKENISATIONNOTIFICATIONV01(
        @WebParam(name = "S_TOKENISATION_NOTIFICATION_V01Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        STOKENISATIONNOTIFICATIONV01Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service create trail and attach document to a trail
     * 			
     * 			INPUT:
     * 				GUEST-OBJID:	ObjID of the guest profile
     * 				
     * 			
     * 			OUTPUT:
     * 				Node1Type:	The first node from trail structure. values only 4 characters long numbers -> e.g. 0000.
     * 				Node2Type:	Increasing number below the NodeType (0000, 0001, 0002 and so on...)
     * 				description:	description of the trail
     * 				status	:	combobox("ts") key value (can be defined in SIHOT)
     * 				beginDate:	format: yyyy-mm-DD
     * 				beginTime:	format: hh:mm
     * 				endDate	:	format: yyyy-mm-DD
     * 				endTime	:	format: hh:mm
     * 				user:		sihot userID
     * 				comment	:	string comment 
     * 
     * 		
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.STRAILATTACHMENTTOEXTERNALDOCUMENTADDV001Response
     */
    @WebMethod(operationName = "S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001")
    @WebResult(name = "S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public STRAILATTACHMENTTOEXTERNALDOCUMENTADDV001Response sTRAILATTACHMENTTOEXTERNALDOCUMENTADDV001(
        @WebParam(name = "S_TRAIL_ATTACHMENT_TO_EXTERNAL_DOCUMENT_ADD_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        STRAILATTACHMENTTOEXTERNALDOCUMENTADDV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for users.
     * 
     * 			INPUT:
     * 				operatorID: 	In case the user is not found in database the ablSalesPerson pool is searched.
     * 
     * 			OUTPUT:
     * 				firstName
     * 				lastName
     * 				phone
     * 				email 
     * 				fax 
     * 				department
     * 				description
     * 				comment
     * 				hotelsPreferred
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SUSERSEARCHV001Response
     */
    @WebMethod(operationName = "S_USER_SEARCH_V001")
    @WebResult(name = "S_USER_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SUSERSEARCHV001Response sUSERSEARCHV001(
        @WebParam(name = "S_USER_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SUSERSEARCHV001Request body);

    /**
     * 
     * 			GENERAL:
     * 				This service searches for yield hurdle productions
     * 
     * 			INPUT:
     * 				from:		start date					Optional
     * 				to:		end date					Optional
     * 				onlyChanges:	show only changes				Optional
     * 
     * 			OUTPUT:
     * 				List of yield hurdle productions matching the request
     * 
     * 		
     * 
     * @param body
     * @return
     *     returns com.gubse.ifs.sihotservices01.SYIELDHURDLEPRODUCTIONSEARCHV001Response
     */
    @WebMethod(operationName = "S_YIELD_HURDLE_PRODUCTION_SEARCH_V001")
    @WebResult(name = "S_YIELD_HURDLE_PRODUCTION_SEARCH_V001Response", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
    public SYIELDHURDLEPRODUCTIONSEARCHV001Response sYIELDHURDLEPRODUCTIONSEARCHV001(
        @WebParam(name = "S_YIELD_HURDLE_PRODUCTION_SEARCH_V001Request", targetNamespace = "http://www.gubse.com/IFS/SihotServices01.xsd", partName = "body")
        SYIELDHURDLEPRODUCTIONSEARCHV001Request body);

}
