/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package GettingStarted;

import java.net.URL;
import java.time.LocalDateTime;

import com.gubse.ifs.sihotservices01.AuthenticateRequest;
import com.gubse.ifs.sihotservices01.AuthenticateResponse;
import com.gubse.ifs.sihotservices01.Authentication;
import com.gubse.ifs.sihotservices01.SGUESTINHOUSESEARCHV001Request;
import com.gubse.ifs.sihotservices01.SGUESTINHOUSESEARCHV001Response;
import com.gubse.ifs.sihotservices01.SihotServices01;
import com.gubse.ifs.sihotservices01.SihotServices01PortType;
import com.gubse.ifs.sihotservices01.AuthenticateRequest.AuthenticationInfos;

public class App {

    String securityID = new String();
    LocalDateTime validUntil = LocalDateTime.now();

    SihotServices01PortType servicePort;

    public App() {
        SihotServices01 service;
        try {
            URL url = new URL(System.getenv("WSDL_URL"));
            service = new SihotServices01(url);
        } catch (Exception e) {
            System.out.println("invalid URL provided,.. use default from WSDL");
            System.out.println(e);
            service = new SihotServices01();
        }

        servicePort = service.getSihotServices01Port();
    }

    public static void main(String[] args) {

        App app = new App();

        System.out.println(app.getSecurityID());
        app.getInhouseGuests("2021-12-22");
    }

    public String getSecurityID() {

        LocalDateTime now = LocalDateTime.now();

        if (securityID.length() > 0 && validUntil.getSecond() > now.getSecond()) {
            return securityID;
        }

        try {
            AuthenticateRequest req = new AuthenticateRequest();
            AuthenticationInfos auth = new AuthenticationInfos();

            auth.setUser(System.getenv("SIHOT_USER"));
            auth.setPassword(System.getenv("SIHOT_PASSWORD"));
            auth.setHotel(System.getenv("SIHOT_HOTEL"));

            req.setAuthenticationInfos(auth);
            AuthenticateResponse res = servicePort.authenticate(req);

            if (res.getResult() != null) {
                if (res.getResult().getSuccess().equalsIgnoreCase("true")) {
                    securityID = res.getAuthentication().get(0).getSecurityID();
                    String duration = res.getAuthentication().get(0).getDurationInSec();
                    
                    LocalDateTime validUntil = now.plusSeconds(Integer.parseInt(duration) - 20);

                    System.out.println(now.toLocalTime());
                    System.out.println("securityID is valid until: " + validUntil.toLocalTime());
                    return securityID;
                } else {
                    System.out.println("did not get a positive result");
                    System.out.println(res.getResult().getErrorMsg());
                    return "null";
                }
            } else {
                System.out.println("did not get a result object");
                return "null";
            }
        } catch (Exception e) {
            System.out.println("Failed to retrieve securityID");
            System.out.println(e.getMessage());
            return "null";
        }
    }

    public SGUESTINHOUSESEARCHV001Response getInhouseGuests(String callingDate) {
        try {
            // ensure the securityID is still valid
            String _securityID = getSecurityID();

            SGUESTINHOUSESEARCHV001Request req = new SGUESTINHOUSESEARCHV001Request();
            Authentication auth = new Authentication();
            SGUESTINHOUSESEARCHV001Request.GuestInHouseSearch search = new SGUESTINHOUSESEARCHV001Request.GuestInHouseSearch();

            auth.setSecurityID(_securityID);
            search.setDate(callingDate);
            req.setAuthentication(auth);
            req.setGuestInHouseSearch(search);

            SGUESTINHOUSESEARCHV001Response res = servicePort.sGUESTINHOUSESEARCHV001(req);
            if (res.getResult() != null) {
                if (res.getResult().getSuccess().equalsIgnoreCase("true")) {
                    System.out.println("got in-house guests");
                    showGuests(res);
                    return res;
                } else {
                    System.out.println("did not get a positive result");
                    System.out.println(res.getResult().getErrorMsg());
                    return null;
                }
            } else {
                System.out.println("did not get a result object");
                return null;
            }
        } catch (

        Exception e) {
            System.out.println("Failed to retrieve securityID");
            System.out.println(e.getMessage());
            return null;
        }
        /*
         * showGuests(S_GUEST_IN_HOUSE_SEARCH_V001Response)
         * return S_GUEST_IN_HOUSE_SEARCH_V001Response;
         */
    }

    void showGuests(SGUESTINHOUSESEARCHV001Response res) {
        if (res.getRoom() == null) {
            System.out.println("Room list was empty");
            return;
        }
        
        for (SGUESTINHOUSESEARCHV001Response.Room room : res.getRoom()) {
            System.out.print("Room type: " + room.getCategory() +  ": ");

            for (SGUESTINHOUSESEARCHV001Response.Room.Person person : room.getPerson() ){
                System.out.print(person.getName1() + ", " + person.getName2());
            }
            System.out.println("");
        }
    }
}
